/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.logger.slf4j;

import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.ComponentMessageThrowable;
import org.jetbrains.annotations.Nullable;

final class UnpackedComponentThrowable
extends Throwable {
    private static final long serialVersionUID = -1L;
    private final Class<? extends Throwable> backingType;

    static Throwable unpack(Throwable maybeRich, Function<Component, String> serializer) {
        if (!(maybeRich instanceof ComponentMessageThrowable)) {
            return maybeRich;
        }
        @Nullable Component message = ((ComponentMessageThrowable)((Object)maybeRich)).componentMessage();
        Throwable cause = maybeRich.getCause() != null ? UnpackedComponentThrowable.unpack(maybeRich.getCause(), serializer) : null;
        Throwable[] suppressed = maybeRich.getSuppressed();
        UnpackedComponentThrowable ret = new UnpackedComponentThrowable(maybeRich.getClass(), serializer.apply(message), cause);
        ret.setStackTrace(maybeRich.getStackTrace());
        if (suppressed.length > 0) {
            for (int i = 0; i < suppressed.length; ++i) {
                ret.addSuppressed(UnpackedComponentThrowable.unpack(suppressed[i], serializer));
            }
        }
        return ret;
    }

    private UnpackedComponentThrowable(Class<? extends Throwable> backingType, String serializedMessage, Throwable cause) {
        super(serializedMessage, cause);
        this.backingType = backingType;
    }

    @Override
    public String toString() {
        String className = this.backingType.getName();
        String message = this.getMessage();
        return message == null ? className : className + ":" + message;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }
}

