/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy;

import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.bstats.MetricsBase;
import com.velocitypowered.proxy.bstats.charts.CustomChart;
import com.velocitypowered.proxy.bstats.charts.DrilldownPie;
import com.velocitypowered.proxy.bstats.charts.SimplePie;
import com.velocitypowered.proxy.bstats.charts.SingleLineChart;
import com.velocitypowered.proxy.bstats.config.MetricsConfig;
import com.velocitypowered.proxy.bstats.json.JsonObjectBuilder;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Metrics {
    private MetricsBase metricsBase;

    private Metrics(Logger logger, int serviceId, boolean defaultEnabled) {
        MetricsConfig config;
        File configFile = Path.of("plugins", "bStats", "config.txt").toFile();
        try {
            config = new MetricsConfig(configFile, defaultEnabled);
        }
        catch (IOException e) {
            logger.error("Failed to create bStats config", (Throwable)e);
            return;
        }
        this.metricsBase = new MetricsBase("server-implementation", config.getServerUUID(), serviceId, config.isEnabled(), this::appendPlatformData, jsonObjectBuilder -> {}, null, () -> true, logger::warn, logger::info, config.isLogErrorsEnabled(), config.isLogSentDataEnabled(), config.isLogResponseStatusTextEnabled(), false);
        if (!config.didExistBefore()) {
            logger.info("Velocity and some of its plugins collect metrics and send them to bStats (https://bStats.org).");
            logger.info("bStats collects some basic information for plugin authors, like how many people use");
            logger.info("their plugin and their total player count. It's recommended to keep bStats enabled, but");
            logger.info("if you're not comfortable with this, you can opt-out by editing the config.txt file in");
            logger.info("the '/plugins/bStats/' folder and setting enabled to false.");
        }
    }

    public void addCustomChart(CustomChart chart) {
        this.metricsBase.addCustomChart(chart);
    }

    private void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    static class VelocityMetrics {
        private static final Logger logger = LogManager.getLogger(Metrics.class);

        VelocityMetrics() {
        }

        static void startMetrics(VelocityServer server, VelocityConfiguration.Metrics metricsConfig) {
            Metrics metrics = new Metrics(logger, 4752, metricsConfig.isEnabled());
            metrics.addCustomChart(new SingleLineChart("players", server::getPlayerCount));
            metrics.addCustomChart(new SingleLineChart("managed_servers", () -> server.getAllServers().size()));
            metrics.addCustomChart(new SimplePie("online_mode", () -> server.getConfiguration().isOnlineMode() ? "online" : "offline"));
            metrics.addCustomChart(new SimplePie("velocity_version", () -> server.getVersion().getVersion()));
            metrics.addCustomChart(new DrilldownPie("java_version", () -> {
                String release;
                HashMap map = new HashMap();
                String javaVersion = System.getProperty("java.version");
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(javaVersion, 1);
                String majorVersion = javaVersion.split("\\.")[0];
                int indexOf = javaVersion.lastIndexOf(46);
                if (majorVersion.equals("1")) {
                    release = "Java " + javaVersion.substring(0, indexOf);
                } else {
                    Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                    if (versionMatcher.find()) {
                        majorVersion = versionMatcher.group(0);
                    }
                    release = "Java " + majorVersion;
                }
                map.put((CallSite)((Object)release), entry);
                return map;
            }));
        }
    }
}

