/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.forge.legacy;

import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhase;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.forge.legacy.LegacyForgeUtil;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import javax.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LegacyForgeHandshakeBackendPhase implements BackendConnectionPhase
{
    NOT_STARTED(0){

        @Override
        LegacyForgeHandshakeBackendPhase nextPhase() {
            return HELLO;
        }
    }
    ,
    HELLO(2){

        @Override
        LegacyForgeHandshakeBackendPhase nextPhase() {
            return SENT_MOD_LIST;
        }

        @Override
        void onTransitionToNewPhase(VelocityServerConnection connection) {
            MinecraftConnection mc = connection.getConnection();
            if (mc != null) {
                mc.setType(ConnectionTypes.LEGACY_FORGE);
            }
            connection.getPlayer().sendLegacyForgeHandshakeResetPacket();
        }
    }
    ,
    SENT_MOD_LIST(3){

        @Override
        LegacyForgeHandshakeBackendPhase nextPhase() {
            return SENT_SERVER_DATA;
        }
    }
    ,
    SENT_SERVER_DATA(-1){

        @Override
        LegacyForgeHandshakeBackendPhase nextPhase() {
            return WAITING_ACK;
        }
    }
    ,
    WAITING_ACK(-1){

        @Override
        LegacyForgeHandshakeBackendPhase nextPhase() {
            return COMPLETE;
        }
    }
    ,
    COMPLETE(null){

        @Override
        public boolean consideredComplete() {
            return true;
        }
    };

    @Nullable
    private final Integer packetToAdvanceOn;

    private LegacyForgeHandshakeBackendPhase(Integer packetToAdvanceOn) {
        this.packetToAdvanceOn = packetToAdvanceOn;
    }

    @Override
    public final boolean handle(VelocityServerConnection serverConnection, ConnectedPlayer player, PluginMessagePacket message) {
        if (message.getChannel().equals("FML|HS")) {
            LegacyForgeHandshakeBackendPhase newPhase = this.getNewPhase(serverConnection, message);
            serverConnection.setConnectionPhase(newPhase);
            player.getConnection().write(message.retain());
            return true;
        }
        return false;
    }

    @Override
    public boolean consideredComplete() {
        return false;
    }

    @Override
    public void onDepartForNewServer(VelocityServerConnection serverConnection, ConnectedPlayer player) {
        player.getPhase().resetConnectionPhase(player);
    }

    void onTransitionToNewPhase(VelocityServerConnection connection) {
    }

    LegacyForgeHandshakeBackendPhase nextPhase() {
        return this;
    }

    private LegacyForgeHandshakeBackendPhase getNewPhase(VelocityServerConnection serverConnection, PluginMessagePacket packet) {
        if (this.packetToAdvanceOn != null && LegacyForgeUtil.getHandshakePacketDiscriminator(packet) == this.packetToAdvanceOn) {
            LegacyForgeHandshakeBackendPhase phaseToTransitionTo = this.nextPhase();
            phaseToTransitionTo.onTransitionToNewPhase(serverConnection);
            return phaseToTransitionTo;
        }
        return this;
    }
}

