/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class PlayPacketQueueInboundHandler
extends ChannelDuplexHandler {
    private final StateRegistry.PacketRegistry.ProtocolRegistry registry;
    private final Queue<Object> queue = new ArrayDeque<Object>();

    public PlayPacketQueueInboundHandler(ProtocolVersion version, ProtocolUtils.Direction direction) {
        this.registry = StateRegistry.CONFIG.getProtocolRegistry(direction, version);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        MinecraftPacket packet;
        if (msg instanceof MinecraftPacket && this.registry.containsPacket(packet = (MinecraftPacket)msg)) {
            ctx.fireChannelRead(msg);
            return;
        }
        this.queue.offer(msg);
    }

    @Override
    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        this.releaseQueue(ctx, false);
        super.channelInactive(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseQueue(ctx, ctx.channel().isActive());
    }

    private void releaseQueue(ChannelHandlerContext ctx, boolean active) {
        Object msg;
        while ((msg = this.queue.poll()) != null) {
            if (active) {
                ctx.fireChannelRead(msg);
                continue;
            }
            ReferenceCountUtil.release(msg);
        }
    }
}

