/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.collect.ImmutableSet;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.registry.DimensionInfo;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JoinGamePacket
implements MinecraftPacket {
    private static final BinaryTagIO.Reader JOINGAME_READER = BinaryTagIO.reader(0x400000L);
    private int entityId;
    private short gamemode;
    private int dimension;
    private long partialHashedSeed;
    private short difficulty;
    private boolean isHardcore;
    private int maxPlayers;
    private @Nullable String levelType;
    private int viewDistance;
    private boolean reducedDebugInfo;
    private boolean showRespawnScreen;
    private boolean doLimitedCrafting;
    private ImmutableSet<String> levelNames;
    private CompoundBinaryTag registry;
    private DimensionInfo dimensionInfo;
    private CompoundBinaryTag currentDimensionData;
    private short previousGamemode;
    private int simulationDistance;
    private @Nullable Pair<String, Long> lastDeathPosition;
    private int portalCooldown;
    private int seaLevel;
    private boolean enforcesSecureChat;

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public short getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(short gamemode) {
        this.gamemode = gamemode;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public long getPartialHashedSeed() {
        return this.partialHashedSeed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public @Nullable String getLevelType() {
        return this.levelType;
    }

    public void setLevelType(@Nullable String levelType) {
        this.levelType = levelType;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    public DimensionInfo getDimensionInfo() {
        return this.dimensionInfo;
    }

    public void setDimensionInfo(DimensionInfo dimensionInfo) {
        this.dimensionInfo = dimensionInfo;
    }

    public short getPreviousGamemode() {
        return this.previousGamemode;
    }

    public void setPreviousGamemode(short previousGamemode) {
        this.previousGamemode = previousGamemode;
    }

    public boolean getIsHardcore() {
        return this.isHardcore;
    }

    public void setIsHardcore(boolean isHardcore) {
        this.isHardcore = isHardcore;
    }

    public boolean getDoLimitedCrafting() {
        return this.doLimitedCrafting;
    }

    public void setDoLimitedCrafting(boolean doLimitedCrafting) {
        this.doLimitedCrafting = doLimitedCrafting;
    }

    public CompoundBinaryTag getCurrentDimensionData() {
        return this.currentDimensionData;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public void setSimulationDistance(int simulationDistance) {
        this.simulationDistance = simulationDistance;
    }

    public Pair<String, Long> getLastDeathPosition() {
        return this.lastDeathPosition;
    }

    public void setLastDeathPosition(Pair<String, Long> lastDeathPosition) {
        this.lastDeathPosition = lastDeathPosition;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public void setSeaLevel(int seaLevel) {
        this.seaLevel = seaLevel;
    }

    public boolean getEnforcesSecureChat() {
        return this.enforcesSecureChat;
    }

    public void setEnforcesSecureChat(boolean enforcesSecureChat) {
        this.enforcesSecureChat = enforcesSecureChat;
    }

    public CompoundBinaryTag getRegistry() {
        return this.registry;
    }

    public String toString() {
        return "JoinGame{entityId=" + this.entityId + ", gamemode=" + this.gamemode + ", dimension=" + this.dimension + ", partialHashedSeed=" + this.partialHashedSeed + ", difficulty=" + this.difficulty + ", isHardcore=" + this.isHardcore + ", maxPlayers=" + this.maxPlayers + ", levelType='" + this.levelType + "', viewDistance=" + this.viewDistance + ", reducedDebugInfo=" + this.reducedDebugInfo + ", showRespawnScreen=" + this.showRespawnScreen + ", doLimitedCrafting=" + this.doLimitedCrafting + ", levelNames=" + String.valueOf(this.levelNames) + ", registry='" + String.valueOf(this.registry) + "', dimensionInfo='" + String.valueOf(this.dimensionInfo) + "', currentDimensionData='" + String.valueOf(this.currentDimensionData) + "', previousGamemode=" + this.previousGamemode + ", simulationDistance=" + this.simulationDistance + ", lastDeathPosition='" + String.valueOf(this.lastDeathPosition) + "', portalCooldown=" + this.portalCooldown + ", seaLevel=" + this.seaLevel + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            this.decode1202Up(buf, version);
        } else if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            this.decode116Up(buf, version);
        } else {
            this.decodeLegacy(buf, version);
        }
    }

    private void decodeLegacy(ByteBuf buf, ProtocolVersion version) {
        this.entityId = buf.readInt();
        this.gamemode = buf.readByte();
        this.isHardcore = (this.gamemode & 8) != 0;
        this.gamemode = (short)(this.gamemode & 0xFFFFFFF7);
        this.dimension = version.noLessThan(ProtocolVersion.MINECRAFT_1_9_1) ? buf.readInt() : (int)buf.readByte();
        if (version.noGreaterThan(ProtocolVersion.MINECRAFT_1_13_2)) {
            this.difficulty = buf.readUnsignedByte();
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_15)) {
            this.partialHashedSeed = buf.readLong();
        }
        this.maxPlayers = buf.readUnsignedByte();
        this.levelType = ProtocolUtils.readString(buf, 16);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_14)) {
            this.viewDistance = ProtocolUtils.readVarInt(buf);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.reducedDebugInfo = buf.readBoolean();
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_15)) {
            this.showRespawnScreen = buf.readBoolean();
        }
    }

    private void decode116Up(ByteBuf buf, ProtocolVersion version) {
        String dimensionIdentifier;
        this.entityId = buf.readInt();
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2)) {
            this.isHardcore = buf.readBoolean();
            this.gamemode = buf.readByte();
        } else {
            this.gamemode = buf.readByte();
            this.isHardcore = (this.gamemode & 8) != 0;
            this.gamemode = (short)(this.gamemode & 0xFFFFFFF7);
        }
        this.previousGamemode = buf.readByte();
        this.levelNames = ImmutableSet.copyOf(ProtocolUtils.readStringArray(buf));
        this.registry = ProtocolUtils.readCompoundTag(buf, version, JOINGAME_READER);
        String levelName = null;
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2) && version.lessThan(ProtocolVersion.MINECRAFT_1_19)) {
            this.currentDimensionData = ProtocolUtils.readCompoundTag(buf, version, JOINGAME_READER);
            dimensionIdentifier = ProtocolUtils.readString(buf);
        } else {
            dimensionIdentifier = ProtocolUtils.readString(buf);
            levelName = ProtocolUtils.readString(buf);
        }
        this.partialHashedSeed = buf.readLong();
        this.maxPlayers = version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2) ? ProtocolUtils.readVarInt(buf) : (int)buf.readUnsignedByte();
        this.viewDistance = ProtocolUtils.readVarInt(buf);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_18)) {
            this.simulationDistance = ProtocolUtils.readVarInt(buf);
        }
        this.reducedDebugInfo = buf.readBoolean();
        this.showRespawnScreen = buf.readBoolean();
        boolean isDebug = buf.readBoolean();
        boolean isFlat = buf.readBoolean();
        this.dimensionInfo = new DimensionInfo(dimensionIdentifier, levelName, isFlat, isDebug, version);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19) && buf.readBoolean()) {
            this.lastDeathPosition = Pair.of(ProtocolUtils.readString(buf), buf.readLong());
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20)) {
            this.portalCooldown = ProtocolUtils.readVarInt(buf);
        }
    }

    private void decode1202Up(ByteBuf buf, ProtocolVersion version) {
        this.entityId = buf.readInt();
        this.isHardcore = buf.readBoolean();
        this.levelNames = ImmutableSet.copyOf(ProtocolUtils.readStringArray(buf));
        this.maxPlayers = ProtocolUtils.readVarInt(buf);
        this.viewDistance = ProtocolUtils.readVarInt(buf);
        this.simulationDistance = ProtocolUtils.readVarInt(buf);
        this.reducedDebugInfo = buf.readBoolean();
        this.showRespawnScreen = buf.readBoolean();
        this.doLimitedCrafting = buf.readBoolean();
        String dimensionKey = "";
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            this.dimension = ProtocolUtils.readVarInt(buf);
        } else {
            dimensionKey = ProtocolUtils.readString(buf);
        }
        String levelName = ProtocolUtils.readString(buf);
        this.partialHashedSeed = buf.readLong();
        this.gamemode = buf.readByte();
        this.previousGamemode = buf.readByte();
        boolean isDebug = buf.readBoolean();
        boolean isFlat = buf.readBoolean();
        this.dimensionInfo = new DimensionInfo(dimensionKey, levelName, isFlat, isDebug, version);
        if (buf.readBoolean()) {
            this.lastDeathPosition = Pair.of(ProtocolUtils.readString(buf), buf.readLong());
        }
        this.portalCooldown = ProtocolUtils.readVarInt(buf);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_21_2)) {
            this.seaLevel = ProtocolUtils.readVarInt(buf);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            this.enforcesSecureChat = buf.readBoolean();
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            this.encode1202Up(buf, version);
        } else if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            this.encode116Up(buf, version);
        } else {
            this.encodeLegacy(buf, version);
        }
    }

    private void encodeLegacy(ByteBuf buf, ProtocolVersion version) {
        buf.writeInt(this.entityId);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2)) {
            buf.writeBoolean(this.isHardcore);
            buf.writeByte(this.gamemode);
        } else {
            buf.writeByte(this.isHardcore ? this.gamemode | 8 : this.gamemode);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_9_1)) {
            buf.writeInt(this.dimension);
        } else {
            buf.writeByte(this.dimension);
        }
        if (version.noGreaterThan(ProtocolVersion.MINECRAFT_1_13_2)) {
            buf.writeByte(this.difficulty);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_15)) {
            buf.writeLong(this.partialHashedSeed);
        }
        buf.writeByte(this.maxPlayers);
        if (this.levelType == null) {
            throw new IllegalStateException("No level type specified.");
        }
        ProtocolUtils.writeString(buf, this.levelType);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_14)) {
            ProtocolUtils.writeVarInt(buf, this.viewDistance);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            buf.writeBoolean(this.reducedDebugInfo);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_15)) {
            buf.writeBoolean(this.showRespawnScreen);
        }
    }

    private void encode116Up(ByteBuf buf, ProtocolVersion version) {
        buf.writeInt(this.entityId);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2)) {
            buf.writeBoolean(this.isHardcore);
            buf.writeByte(this.gamemode);
        } else {
            buf.writeByte(this.isHardcore ? this.gamemode | 8 : this.gamemode);
        }
        buf.writeByte(this.previousGamemode);
        ProtocolUtils.writeStringArray(buf, (String[])this.levelNames.toArray(String[]::new));
        ProtocolUtils.writeBinaryTag(buf, version, this.registry);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2) && version.lessThan(ProtocolVersion.MINECRAFT_1_19)) {
            ProtocolUtils.writeBinaryTag(buf, version, this.currentDimensionData);
            ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
        } else {
            ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
            ProtocolUtils.writeString(buf, this.dimensionInfo.getLevelName());
        }
        buf.writeLong(this.partialHashedSeed);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2)) {
            ProtocolUtils.writeVarInt(buf, this.maxPlayers);
        } else {
            buf.writeByte(this.maxPlayers);
        }
        ProtocolUtils.writeVarInt(buf, this.viewDistance);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_18)) {
            ProtocolUtils.writeVarInt(buf, this.simulationDistance);
        }
        buf.writeBoolean(this.reducedDebugInfo);
        buf.writeBoolean(this.showRespawnScreen);
        buf.writeBoolean(this.dimensionInfo.isDebugType());
        buf.writeBoolean(this.dimensionInfo.isFlat());
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            if (this.lastDeathPosition != null) {
                buf.writeBoolean(true);
                ProtocolUtils.writeString(buf, this.lastDeathPosition.key());
                buf.writeLong(this.lastDeathPosition.value());
            } else {
                buf.writeBoolean(false);
            }
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20)) {
            ProtocolUtils.writeVarInt(buf, this.portalCooldown);
        }
    }

    private void encode1202Up(ByteBuf buf, ProtocolVersion version) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.isHardcore);
        ProtocolUtils.writeStringArray(buf, (String[])this.levelNames.toArray(String[]::new));
        ProtocolUtils.writeVarInt(buf, this.maxPlayers);
        ProtocolUtils.writeVarInt(buf, this.viewDistance);
        ProtocolUtils.writeVarInt(buf, this.simulationDistance);
        buf.writeBoolean(this.reducedDebugInfo);
        buf.writeBoolean(this.showRespawnScreen);
        buf.writeBoolean(this.doLimitedCrafting);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            ProtocolUtils.writeVarInt(buf, this.dimension);
        } else {
            ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
        }
        ProtocolUtils.writeString(buf, this.dimensionInfo.getLevelName());
        buf.writeLong(this.partialHashedSeed);
        buf.writeByte(this.gamemode);
        buf.writeByte(this.previousGamemode);
        buf.writeBoolean(this.dimensionInfo.isDebugType());
        buf.writeBoolean(this.dimensionInfo.isFlat());
        if (this.lastDeathPosition != null) {
            buf.writeBoolean(true);
            ProtocolUtils.writeString(buf, this.lastDeathPosition.key());
            buf.writeLong(this.lastDeathPosition.value());
        } else {
            buf.writeBoolean(false);
        }
        ProtocolUtils.writeVarInt(buf, this.portalCooldown);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_21_2)) {
            ProtocolUtils.writeVarInt(buf, this.seaLevel);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            buf.writeBoolean(this.enforcesSecureChat);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

