/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.connection;

import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.Player;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@AwaitingEvent
@ApiStatus.Experimental
public final class PreTransferEvent
implements ResultedEvent<TransferResult> {
    private final InetSocketAddress originalAddress;
    private final Player player;
    private TransferResult result = TransferResult.ALLOWED;

    public PreTransferEvent(Player player, InetSocketAddress address) {
        this.player = Objects.requireNonNull(player);
        this.originalAddress = Objects.requireNonNull(address);
    }

    public Player player() {
        return this.player;
    }

    public InetSocketAddress originalAddress() {
        return this.originalAddress;
    }

    @Override
    public TransferResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(TransferResult result) {
        Objects.requireNonNull(result);
        this.result = result;
    }

    public static class TransferResult
    implements ResultedEvent.Result {
        private static final TransferResult ALLOWED = new TransferResult(true, null);
        private static final TransferResult DENIED = new TransferResult(false, null);
        private final InetSocketAddress address;
        private final boolean allowed;

        private TransferResult(boolean allowed, InetSocketAddress address) {
            this.address = address;
            this.allowed = allowed;
        }

        public static TransferResult allowed() {
            return ALLOWED;
        }

        public static TransferResult denied() {
            return DENIED;
        }

        public static TransferResult transferTo(InetSocketAddress address) {
            Objects.requireNonNull(address);
            return new TransferResult(true, address);
        }

        @Override
        public boolean isAllowed() {
            return this.allowed;
        }

        @Nullable
        public InetSocketAddress address() {
            return this.address;
        }
    }
}

