/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.player.resourcepack.handler;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.resourcepack.ResourcePackResponseBundle;
import com.velocitypowered.proxy.connection.player.resourcepack.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.Legacy117ResourcePackHandler;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.LegacyResourcePackHandler;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.ModernResourcePackHandler;
import com.velocitypowered.proxy.protocol.packet.ResourcePackRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponsePacket;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.buffer.ByteBufUtil;
import java.util.Collection;
import java.util.UUID;
import net.kyori.adventure.resource.ResourcePackRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ResourcePackHandler {
    protected final ConnectedPlayer player;
    protected final VelocityServer server;

    protected ResourcePackHandler(ConnectedPlayer player, VelocityServer server) {
        this.player = player;
        this.server = server;
    }

    @NotNull
    public static ResourcePackHandler create(ConnectedPlayer player, VelocityServer server) {
        ProtocolVersion protocolVersion = player.getProtocolVersion();
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_17)) {
            return new LegacyResourcePackHandler(player, server);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            return new Legacy117ResourcePackHandler(player, server);
        }
        return new ModernResourcePackHandler(player, server);
    }

    @Nullable
    public abstract ResourcePackInfo getFirstAppliedPack();

    @Nullable
    public abstract ResourcePackInfo getFirstPendingPack();

    @NotNull
    public abstract Collection<ResourcePackInfo> getAppliedResourcePacks();

    @NotNull
    public abstract Collection<ResourcePackInfo> getPendingResourcePacks();

    public abstract void clearAppliedResourcePacks();

    public abstract boolean remove(UUID var1);

    public abstract void queueResourcePack(@NotNull ResourcePackInfo var1);

    public void queueResourcePack(@NotNull ResourcePackRequest request) {
        for (net.kyori.adventure.resource.ResourcePackInfo pack : request.packs()) {
            ResourcePackInfo resourcePackInfo = VelocityResourcePackInfo.fromAdventureRequest(request, pack);
            this.checkAlreadyAppliedPack(resourcePackInfo.getHash());
            this.queueResourcePack(resourcePackInfo);
        }
    }

    protected void sendResourcePackRequestPacket(@NotNull ResourcePackInfo queued) {
        ResourcePackRequestPacket request = new ResourcePackRequestPacket();
        request.setId(queued.getId());
        request.setUrl(queued.getUrl());
        if (queued.getHash() != null) {
            request.setHash(ByteBufUtil.hexDump(queued.getHash()));
        } else {
            request.setHash("");
        }
        request.setRequired(queued.getShouldForce());
        request.setPrompt(queued.getPrompt() == null ? null : new ComponentHolder(this.player.getProtocolVersion(), this.player.translateMessage(queued.getPrompt())));
        this.player.getConnection().write(request);
    }

    public abstract boolean onResourcePackResponse(@NotNull ResourcePackResponseBundle var1);

    protected boolean handleResponseResult(@Nullable ResourcePackInfo queued, @NotNull ResourcePackResponseBundle bundle) {
        VelocityServerConnection connectionInFlight;
        boolean handled;
        boolean bl = handled = queued != null && queued.getOriginalOrigin() == ResourcePackInfo.Origin.PLUGIN_ON_PROXY;
        if (!handled && (connectionInFlight = this.player.getConnectionInFlight()) != null && connectionInFlight.getConnection() != null) {
            connectionInFlight.getConnection().write(new ResourcePackResponsePacket(bundle.uuid(), bundle.hash(), bundle.status()));
        }
        return handled;
    }

    public abstract boolean hasPackAppliedByHash(byte[] var1);

    public void checkAlreadyAppliedPack(byte[] hash) {
        if (this.hasPackAppliedByHash(hash)) {
            throw new IllegalStateException("Cannot apply a resource pack already applied");
        }
    }
}

