/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.network;

import com.velocitypowered.proxy.util.concurrent.VelocityNettyThreadFactory;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.channel.uring.IoUringSocketChannel;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

public enum TransportType {
    NIO("NIO", NioServerSocketChannel::new, NioSocketChannel::new, NioDatagramChannel::new, NioIoHandler::newFactory),
    EPOLL("epoll", EpollServerSocketChannel::new, EpollSocketChannel::new, EpollDatagramChannel::new, EpollIoHandler::newFactory),
    KQUEUE("kqueue", KQueueServerSocketChannel::new, KQueueSocketChannel::new, KQueueDatagramChannel::new, KQueueIoHandler::newFactory),
    IO_URING("io_uring", IoUringServerSocketChannel::new, IoUringSocketChannel::new, IoUringDatagramChannel::new, IoUringIoHandler::newFactory);

    final String name;
    final ChannelFactory<? extends ServerSocketChannel> serverSocketChannelFactory;
    final ChannelFactory<? extends SocketChannel> socketChannelFactory;
    final ChannelFactory<? extends DatagramChannel> datagramChannelFactory;
    final Supplier<IoHandlerFactory> ioHandlerFactorySupplier;

    private TransportType(String name, ChannelFactory<? extends ServerSocketChannel> serverSocketChannelFactory, ChannelFactory<? extends SocketChannel> socketChannelFactory, ChannelFactory<? extends DatagramChannel> datagramChannelFactory, Supplier<IoHandlerFactory> ioHandlerFactorySupplier) {
        this.name = name;
        this.serverSocketChannelFactory = serverSocketChannelFactory;
        this.socketChannelFactory = socketChannelFactory;
        this.datagramChannelFactory = datagramChannelFactory;
        this.ioHandlerFactorySupplier = ioHandlerFactorySupplier;
    }

    public String toString() {
        return this.name;
    }

    public EventLoopGroup createEventLoopGroup(Type type) {
        return new MultiThreadIoEventLoopGroup(0, TransportType.createThreadFactory(this.name, type), this.ioHandlerFactorySupplier.get());
    }

    private static ThreadFactory createThreadFactory(String name, Type type) {
        return new VelocityNettyThreadFactory("Netty " + name + " " + type.toString() + " #%d");
    }

    public static TransportType bestType() {
        if (Boolean.getBoolean("velocity.disable-native-transport")) {
            return NIO;
        }
        if (IoUring.isAvailable() && Boolean.getBoolean("velocity.enable-iouring-transport")) {
            return IO_URING;
        }
        if (Epoll.isAvailable()) {
            return EPOLL;
        }
        if (KQueue.isAvailable()) {
            return KQUEUE;
        }
        return NIO;
    }

    public static enum Type {
        BOSS("Boss"),
        WORKER("Worker");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

