/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.text.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class ComponentHolder {
    private static final Logger logger = LogManager.getLogger(ComponentHolder.class);
    public static final int DEFAULT_MAX_STRING_SIZE = 262143;
    private final ProtocolVersion version;
    private @MonotonicNonNull Component component;
    private @MonotonicNonNull String json;
    private @MonotonicNonNull BinaryTag binaryTag;

    public ComponentHolder(ProtocolVersion version, Component component) {
        this.version = version;
        this.component = component;
    }

    public ComponentHolder(ProtocolVersion version, String json) {
        this.version = version;
        this.json = json;
    }

    public ComponentHolder(ProtocolVersion version, BinaryTag binaryTag) {
        this.version = version;
        this.binaryTag = binaryTag;
    }

    public Component getComponent() {
        if (this.component == null) {
            if (this.json != null) {
                this.component = ProtocolUtils.getJsonChatSerializer(this.version).deserialize(this.json);
            } else if (this.binaryTag != null) {
                try {
                    this.json = ComponentHolder.deserialize(this.binaryTag).toString();
                    this.component = ProtocolUtils.getJsonChatSerializer(this.version).deserialize(this.json);
                }
                catch (Exception ex) {
                    logger.error("Error converting binary component to JSON component! Binary: " + String.valueOf(this.binaryTag) + " JSON: " + this.json, (Throwable)ex);
                    throw ex;
                }
            }
        }
        return this.component;
    }

    public String getJson() {
        if (this.json == null) {
            this.json = (String)ProtocolUtils.getJsonChatSerializer(this.version).serialize(this.getComponent());
        }
        return this.json;
    }

    public BinaryTag getBinaryTag() {
        if (this.binaryTag == null) {
            this.binaryTag = ComponentHolder.serialize(ProtocolUtils.getJsonChatSerializer(this.version).serializeToTree(this.getComponent()));
        }
        return this.binaryTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BinaryTag serialize(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number = json.getAsNumber();
                if (number instanceof Byte) {
                    return ByteBinaryTag.byteBinaryTag((Byte)number);
                }
                if (number instanceof Short) {
                    return ShortBinaryTag.shortBinaryTag((Short)number);
                }
                if (number instanceof Integer) {
                    return IntBinaryTag.intBinaryTag((Integer)number);
                }
                if (number instanceof Long) {
                    return LongBinaryTag.longBinaryTag((Long)number);
                }
                if (number instanceof Float) {
                    return FloatBinaryTag.floatBinaryTag(((Float)number).floatValue());
                }
                if (number instanceof Double) {
                    return DoubleBinaryTag.doubleBinaryTag((Double)number);
                }
                if (!(number instanceof LazilyParsedNumber)) return EndBinaryTag.endBinaryTag();
                return IntBinaryTag.intBinaryTag(number.intValue());
            }
            if (jsonPrimitive.isString()) {
                return StringBinaryTag.stringBinaryTag(jsonPrimitive.getAsString());
            }
            if (!jsonPrimitive.isBoolean()) throw new IllegalArgumentException("Unknown JSON primitive: " + String.valueOf(jsonPrimitive));
            return ByteBinaryTag.byteBinaryTag((byte)(jsonPrimitive.getAsBoolean() ? 1 : 0));
        }
        if (json instanceof JsonObject) {
            CompoundBinaryTag.Builder compound = CompoundBinaryTag.builder();
            for (Map.Entry<String, JsonElement> property : ((JsonObject)json).entrySet()) {
                compound.put(property.getKey(), ComponentHolder.serialize(property.getValue()));
            }
            return compound.build();
        }
        if (!(json instanceof JsonArray)) return EndBinaryTag.endBinaryTag();
        List<JsonElement> jsonArray = ((JsonArray)json).asList();
        if (jsonArray.isEmpty()) {
            return ListBinaryTag.empty();
        }
        ArrayList<BinaryTag> tagItems = new ArrayList<BinaryTag>(jsonArray.size());
        BinaryTagType<? extends BinaryTag> listType = null;
        for (JsonElement jsonEl : jsonArray) {
            BinaryTag tag2 = ComponentHolder.serialize(jsonEl);
            tagItems.add(tag2);
            if (listType == null) {
                listType = tag2.type();
                continue;
            }
            if (listType == tag2.type()) continue;
            listType = BinaryTagTypes.COMPOUND;
        }
        switch (listType.id()) {
            case 1: {
                byte[] bytes = new byte[jsonArray.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = jsonArray.get(i).getAsNumber().byteValue();
                }
                return ByteArrayBinaryTag.byteArrayBinaryTag(bytes);
            }
            case 3: {
                int[] ints = new int[jsonArray.size()];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = jsonArray.get(i).getAsNumber().intValue();
                }
                return IntArrayBinaryTag.intArrayBinaryTag(ints);
            }
            case 4: {
                long[] longs = new long[jsonArray.size()];
                for (int i = 0; i < longs.length; ++i) {
                    longs[i] = jsonArray.get(i).getAsNumber().longValue();
                }
                return LongArrayBinaryTag.longArrayBinaryTag(longs);
            }
            case 10: {
                tagItems.replaceAll(tag -> {
                    if (tag.type() == BinaryTagTypes.COMPOUND) {
                        return tag;
                    }
                    return ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("", (BinaryTag)tag)).build();
                });
            }
        }
        return ListBinaryTag.listBinaryTag(listType, tagItems);
    }

    public static JsonElement deserialize(BinaryTag tag) {
        switch (tag.type().id()) {
            case 1: {
                return new JsonPrimitive(((ByteBinaryTag)tag).value());
            }
            case 2: {
                return new JsonPrimitive(((ShortBinaryTag)tag).value());
            }
            case 3: {
                return new JsonPrimitive(((IntBinaryTag)tag).value());
            }
            case 4: {
                return new JsonPrimitive(((LongBinaryTag)tag).value());
            }
            case 5: {
                return new JsonPrimitive(Float.valueOf(((FloatBinaryTag)tag).value()));
            }
            case 6: {
                return new JsonPrimitive(((DoubleBinaryTag)tag).value());
            }
            case 7: {
                byte[] byteArray = ((ByteArrayBinaryTag)tag).value();
                JsonArray jsonByteArray = new JsonArray(byteArray.length);
                for (byte b : byteArray) {
                    jsonByteArray.add(new JsonPrimitive(b));
                }
                return jsonByteArray;
            }
            case 8: {
                return new JsonPrimitive(((StringBinaryTag)tag).value());
            }
            case 9: {
                ListBinaryTag items = (ListBinaryTag)tag;
                JsonArray jsonList = new JsonArray(items.size());
                for (BinaryTag subTag : items) {
                    jsonList.add(ComponentHolder.deserialize(subTag));
                }
                return jsonList;
            }
            case 10: {
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                JsonObject jsonObject = new JsonObject();
                compound.keySet().forEach(key -> jsonObject.add(key.isEmpty() ? "text" : key, ComponentHolder.deserialize(compound.get((String)key))));
                return jsonObject;
            }
            case 11: {
                int[] intArray = ((IntArrayBinaryTag)tag).value();
                JsonArray jsonIntArray = new JsonArray(intArray.length);
                for (int i : intArray) {
                    jsonIntArray.add(new JsonPrimitive(i));
                }
                return jsonIntArray;
            }
            case 12: {
                long[] longArray = ((LongArrayBinaryTag)tag).value();
                JsonArray jsonLongArray = new JsonArray(longArray.length);
                for (long l : longArray) {
                    jsonLongArray.add(new JsonPrimitive(l));
                }
                return jsonLongArray;
            }
        }
        throw new IllegalArgumentException("Unknown NBT tag: " + String.valueOf(tag));
    }

    public static ComponentHolder read(ByteBuf buf, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            return new ComponentHolder(version, ProtocolUtils.readBinaryTag(buf, version, BinaryTagIO.reader()));
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_13)) {
            return new ComponentHolder(version, ProtocolUtils.readString(buf, 262143));
        }
        return new ComponentHolder(version, ProtocolUtils.readString(buf));
    }

    public void write(ByteBuf buf) {
        if (this.version.noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            ProtocolUtils.writeBinaryTag(buf, this.version, this.getBinaryTag());
        } else {
            ProtocolUtils.writeString(buf, this.getJson());
        }
    }
}

