/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ChatType;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.buffer.ByteBuf;

public class SystemChatPacket
implements MinecraftPacket {
    private ComponentHolder component;
    private ChatType type;

    public SystemChatPacket() {
    }

    public SystemChatPacket(ComponentHolder component, ChatType type) {
        this.component = component;
        this.type = type;
    }

    public ChatType getType() {
        return this.type;
    }

    public ComponentHolder getComponent() {
        return this.component;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.component = ComponentHolder.read(buf, version);
        this.type = version.noLessThan(ProtocolVersion.MINECRAFT_1_19_1) ? (buf.readBoolean() ? ChatType.GAME_INFO : ChatType.SYSTEM) : ChatType.values()[ProtocolUtils.readVarInt(buf)];
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        block5: {
            block4: {
                this.component.write(buf);
                if (!version.noLessThan(ProtocolVersion.MINECRAFT_1_19_1)) break block4;
                switch (this.type) {
                    case SYSTEM: {
                        buf.writeBoolean(false);
                        break block5;
                    }
                    case GAME_INFO: {
                        buf.writeBoolean(true);
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid chat type");
                    }
                }
            }
            ProtocolUtils.writeVarInt(buf, this.type.getId());
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

