/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public class PlayerResourcePackStatusEvent {
    private final Player player;
    private final @MonotonicNonNull UUID packId;
    private final Status status;
    private final @MonotonicNonNull ResourcePackInfo packInfo;
    private boolean overwriteKick;

    @Deprecated
    public PlayerResourcePackStatusEvent(Player player, Status status) {
        this(player, null, status, null);
    }

    @Deprecated
    public PlayerResourcePackStatusEvent(Player player, Status status, ResourcePackInfo packInfo) {
        this(player, null, status, packInfo);
    }

    public PlayerResourcePackStatusEvent(Player player, UUID packId, Status status, ResourcePackInfo packInfo) {
        this.player = Preconditions.checkNotNull(player, "player");
        this.packId = packId == null ? (packInfo == null ? null : packInfo.getId()) : packId;
        this.status = Preconditions.checkNotNull(status, "status");
        this.packInfo = packInfo;
    }

    public Player getPlayer() {
        return this.player;
    }

    public @Nullable UUID getPackId() {
        return this.packId;
    }

    public Status getStatus() {
        return this.status;
    }

    public @Nullable ResourcePackInfo getPackInfo() {
        return this.packInfo;
    }

    public boolean isOverwriteKick() {
        return this.overwriteKick;
    }

    public void setOverwriteKick(boolean overwriteKick) {
        Preconditions.checkArgument(this.player.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_17), "overwriteKick is not supported on 1.17 or newer");
        this.overwriteKick = overwriteKick;
    }

    public String toString() {
        return "PlayerResourcePackStatusEvent{player=" + String.valueOf(this.player) + ", status=" + String.valueOf((Object)this.status) + ", packInfo=" + String.valueOf(this.packInfo) + "}";
    }

    public static enum Status {
        SUCCESSFUL,
        DECLINED,
        FAILED_DOWNLOAD,
        ACCEPTED,
        DOWNLOADED,
        INVALID_URL,
        FAILED_RELOAD,
        DISCARDED;


        public boolean isIntermediate() {
            return this == ACCEPTED || this == DOWNLOADED;
        }
    }
}

