/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.natives.util;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.util.BufferPreference;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

public class MoreByteBufUtils {
    private MoreByteBufUtils() {
        throw new AssertionError();
    }

    public static ByteBuf ensureCompatible(ByteBufAllocator alloc, Native nativeStuff, ByteBuf buf) {
        if (MoreByteBufUtils.isCompatible(nativeStuff, buf)) {
            return buf.retain();
        }
        ByteBuf newBuf = MoreByteBufUtils.preferredBuffer(alloc, nativeStuff, buf.readableBytes());
        newBuf.writeBytes(buf);
        return newBuf;
    }

    private static boolean isCompatible(Native nativeStuff, ByteBuf buf) {
        BufferPreference preferred = nativeStuff.preferredBufferType();
        return switch (preferred) {
            default -> throw new IncompatibleClassChangeError();
            case BufferPreference.DIRECT_PREFERRED, BufferPreference.HEAP_PREFERRED -> true;
            case BufferPreference.DIRECT_REQUIRED -> buf.hasMemoryAddress();
            case BufferPreference.HEAP_REQUIRED -> buf.hasArray();
        };
    }

    public static ByteBuf preferredBuffer(ByteBufAllocator alloc, Native nativeStuff, int initialCapacity) {
        return switch (nativeStuff.preferredBufferType()) {
            default -> throw new IncompatibleClassChangeError();
            case BufferPreference.HEAP_PREFERRED, BufferPreference.HEAP_REQUIRED -> alloc.heapBuffer(initialCapacity);
            case BufferPreference.DIRECT_PREFERRED, BufferPreference.DIRECT_REQUIRED -> alloc.directBuffer(initialCapacity);
        };
    }
}

