/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.registrar;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.proxy.command.VelocityCommands;
import com.velocitypowered.proxy.command.registrar.CommandRegistrar;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.lock.qual.GuardedBy;

abstract class AbstractCommandRegistrar<T extends Command>
implements CommandRegistrar<T> {
    private final @GuardedBy(value={"lock"}) RootCommandNode<CommandSource> root;
    private final Lock lock;

    protected AbstractCommandRegistrar(RootCommandNode<CommandSource> root, Lock lock) {
        this.root = Preconditions.checkNotNull(root, "root");
        this.lock = Preconditions.checkNotNull(lock, "lock");
    }

    protected void register(LiteralCommandNode<CommandSource> node) {
        this.lock.lock();
        try {
            this.root.removeChildByName(node.getName());
            this.root.addChild(node);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void register(LiteralCommandNode<CommandSource> node, String secondaryAlias) {
        LiteralCommandNode<CommandSource> copy = VelocityCommands.shallowCopy(node, secondaryAlias);
        this.register(copy);
    }
}

