/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.player.bundle;

import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.BundleDelimiterPacket;
import java.util.concurrent.CompletableFuture;

public final class BundleDelimiterHandler {
    private final ConnectedPlayer player;
    private boolean inBundleSession = false;
    private CompletableFuture<Void> finishedBundleSessionFuture;

    public BundleDelimiterHandler(ConnectedPlayer player) {
        this.player = player;
    }

    public boolean isInBundleSession() {
        return this.inBundleSession;
    }

    public void toggleBundleSession() {
        if (this.inBundleSession) {
            this.finishedBundleSessionFuture.complete(null);
            this.finishedBundleSessionFuture = null;
        } else {
            this.finishedBundleSessionFuture = new CompletableFuture();
        }
        this.inBundleSession = !this.inBundleSession;
    }

    public CompletableFuture<Void> bundlePackets(Runnable sendPackets) {
        MinecraftConnection connection;
        VelocityServerConnection connectedServer = this.player.getConnectedServer();
        MinecraftConnection minecraftConnection = connection = connectedServer == null ? null : connectedServer.getConnection();
        if (connection == null) {
            this.sendPackets(sendPackets);
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        connection.eventLoop().execute(() -> {
            if (this.inBundleSession) {
                this.finishedBundleSessionFuture.thenRun(() -> {
                    this.sendPackets(sendPackets);
                    future.complete(null);
                });
            } else {
                if (connection.getState() == StateRegistry.PLAY) {
                    this.sendPackets(sendPackets);
                } else {
                    sendPackets.run();
                }
                future.complete(null);
            }
        });
        return future;
    }

    private void sendPackets(Runnable sendPackets) {
        this.player.getConnection().write(BundleDelimiterPacket.INSTANCE);
        try {
            sendPackets.run();
        }
        finally {
            this.player.getConnection().write(BundleDelimiterPacket.INSTANCE);
        }
    }
}

