/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.VelocityConstants;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EncryptionResponsePacket
implements MinecraftPacket {
    private static final QuietDecoderException NO_SALT = new QuietDecoderException("Encryption response didn't contain salt");
    private byte[] sharedSecret = VelocityConstants.EMPTY_BYTE_ARRAY;
    private byte[] verifyToken = VelocityConstants.EMPTY_BYTE_ARRAY;
    private @Nullable Long salt;

    public byte[] getSharedSecret() {
        return (byte[])this.sharedSecret.clone();
    }

    public byte[] getVerifyToken() {
        return (byte[])this.verifyToken.clone();
    }

    public long getSalt() {
        if (this.salt == null) {
            throw NO_SALT;
        }
        return this.salt;
    }

    public String toString() {
        return "EncryptionResponse{sharedSecret=" + Arrays.toString(this.sharedSecret) + ", verifyToken=" + Arrays.toString(this.verifyToken) + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.sharedSecret = ProtocolUtils.readByteArray(buf, 128);
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19) && version.lessThan(ProtocolVersion.MINECRAFT_1_19_3) && !buf.readBoolean()) {
                this.salt = buf.readLong();
            }
            this.verifyToken = ProtocolUtils.readByteArray(buf, version.noLessThan(ProtocolVersion.MINECRAFT_1_19) ? 256 : 128);
        } else {
            this.sharedSecret = ProtocolUtils.readByteArray17(buf);
            this.verifyToken = ProtocolUtils.readByteArray17(buf);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            ProtocolUtils.writeByteArray(buf, this.sharedSecret);
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19) && version.lessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
                if (this.salt != null) {
                    buf.writeBoolean(false);
                    buf.writeLong(this.salt);
                } else {
                    buf.writeBoolean(true);
                }
            }
            ProtocolUtils.writeByteArray(buf, this.verifyToken);
        } else {
            ProtocolUtils.writeByteArray17(this.sharedSecret, buf, false);
            ProtocolUtils.writeByteArray17(this.verifyToken, buf, false);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    @Override
    public int decodeExpectedMaxLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        int base = 260;
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
            return base + 128;
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            base += 137;
        }
        return base;
    }

    @Override
    public int decodeExpectedMinLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        int base = this.decodeExpectedMaxLength(buf, direction, version);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            base -= 136;
        }
        return base;
    }
}

