/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.chat.CommandHandler;
import net.kyori.adventure.text.Component;

public abstract class RateLimitedCommandHandler<T extends MinecraftPacket>
implements CommandHandler<T> {
    private final Player player;
    private final VelocityServer velocityServer;
    private int failedAttempts;

    protected RateLimitedCommandHandler(Player player, VelocityServer velocityServer) {
        this.player = player;
        this.velocityServer = velocityServer;
    }

    @Override
    public boolean handlePlayerCommand(MinecraftPacket packet) {
        if (this.packetClass().isInstance(packet)) {
            if (!this.velocityServer.getCommandRateLimiter().attempt(this.player.getUniqueId())) {
                if (this.velocityServer.getConfiguration().isKickOnCommandRateLimit() && this.failedAttempts++ >= this.velocityServer.getConfiguration().getKickAfterRateLimitedCommands()) {
                    this.player.disconnect(Component.translatable("velocity.kick.command-rate-limit"));
                }
                if (this.velocityServer.getConfiguration().isForwardCommandsIfRateLimited()) {
                    return false;
                }
            } else {
                this.failedAttempts = 0;
            }
            this.handlePlayerCommandInternal((MinecraftPacket)this.packetClass().cast(packet));
            return true;
        }
        return false;
    }
}

