/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.UuidUtils;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.util.VelocityProperties;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerLoginSuccessPacket
implements MinecraftPacket {
    private @Nullable UUID uuid;
    private @Nullable String username;
    private @Nullable List<GameProfile.Property> properties;
    private static final boolean strictErrorHandling = VelocityProperties.readBoolean("velocity.strictErrorHandling", true);

    public UUID getUuid() {
        if (this.uuid == null) {
            throw new IllegalStateException("No UUID specified!");
        }
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getUsername() {
        if (this.username == null) {
            throw new IllegalStateException("No username specified!");
        }
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<GameProfile.Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<GameProfile.Property> properties) {
        this.properties = properties;
    }

    public String toString() {
        return "ServerLoginSuccess{uuid=" + String.valueOf(this.uuid) + ", username='" + this.username + "', properties='" + String.valueOf(this.properties) + "'}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.uuid = version.noLessThan(ProtocolVersion.MINECRAFT_1_19) ? ProtocolUtils.readUuid(buf) : (version.noLessThan(ProtocolVersion.MINECRAFT_1_16) ? ProtocolUtils.readUuidIntArray(buf) : (version.noLessThan(ProtocolVersion.MINECRAFT_1_7_6) ? UUID.fromString(ProtocolUtils.readString(buf, 36)) : UuidUtils.fromUndashed(ProtocolUtils.readString(buf, 32))));
        this.username = ProtocolUtils.readString(buf, 16);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            this.properties = ProtocolUtils.readProperties(buf);
        }
        if (version == ProtocolVersion.MINECRAFT_1_20_5 || version == ProtocolVersion.MINECRAFT_1_21) {
            buf.readBoolean();
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.uuid == null) {
            throw new IllegalStateException("No UUID specified!");
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            ProtocolUtils.writeUuid(buf, this.uuid);
        } else if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            ProtocolUtils.writeUuidIntArray(buf, this.uuid);
        } else if (version.noLessThan(ProtocolVersion.MINECRAFT_1_7_6)) {
            ProtocolUtils.writeString(buf, this.uuid.toString());
        } else {
            ProtocolUtils.writeString(buf, UuidUtils.toUndashed(this.uuid));
        }
        if (this.username == null) {
            throw new IllegalStateException("No username specified!");
        }
        ProtocolUtils.writeString(buf, this.username);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            if (this.properties == null) {
                ProtocolUtils.writeVarInt(buf, 0);
            } else {
                ProtocolUtils.writeProperties(buf, this.properties);
            }
        }
        if (version == ProtocolVersion.MINECRAFT_1_20_5 || version == ProtocolVersion.MINECRAFT_1_21) {
            buf.writeBoolean(strictErrorHandling);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

