/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhases;
import com.velocitypowered.proxy.connection.backend.BackendPlaySessionHandler;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.forge.legacy.LegacyForgeHandshakeBackendPhase;
import com.velocitypowered.proxy.connection.util.ConnectionMessages;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.DisconnectPacket;
import com.velocitypowered.proxy.protocol.packet.JoinGamePacket;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransitionSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(TransitionSessionHandler.class);
    private final VelocityServer server;
    private final VelocityServerConnection serverConn;
    private final CompletableFuture<ConnectionRequestResults.Impl> resultFuture;
    private final BungeeCordMessageResponder bungeecordMessageResponder;

    TransitionSessionHandler(VelocityServer server, VelocityServerConnection serverConn, CompletableFuture<ConnectionRequestResults.Impl> resultFuture) {
        this.server = server;
        this.serverConn = serverConn;
        this.resultFuture = resultFuture;
        this.bungeecordMessageResponder = new BungeeCordMessageResponder(server, serverConn.getPlayer());
    }

    @Override
    public boolean beforeHandle() {
        if (!this.serverConn.isActive()) {
            this.serverConn.disconnect();
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(KeepAlivePacket packet) {
        this.serverConn.ensureConnected().write(packet);
        return true;
    }

    @Override
    public boolean handle(JoinGamePacket packet) {
        MinecraftConnection smc = this.serverConn.ensureConnected();
        RegisteredServer previousServer = this.serverConn.getPreviousServer().orElse(null);
        ConnectedPlayer player = this.serverConn.getPlayer();
        VelocityServerConnection existingConnection = player.getConnectedServer();
        if (existingConnection != null) {
            player.setConnectedServer(null);
            existingConnection.disconnect();
            player.sendKeepAlive();
        }
        player.clearPlayerListHeaderAndFooter();
        smc.setAutoReading(false);
        ((CompletableFuture)this.server.getEventManager().fire(new ServerConnectedEvent(player, this.serverConn.getServer(), previousServer)).thenRunAsync(() -> {
            ClientPlaySessionHandler playHandler;
            if (!this.serverConn.isActive()) {
                this.serverConn.disconnect();
                return;
            }
            MinecraftSessionHandler patt0$temp = player.getConnection().getActiveSessionHandler();
            if (patt0$temp instanceof ClientPlaySessionHandler) {
                ClientPlaySessionHandler sessionHandler;
                playHandler = sessionHandler = (ClientPlaySessionHandler)patt0$temp;
            } else {
                playHandler = new ClientPlaySessionHandler(this.server, player);
                player.getConnection().setActiveSessionHandler(StateRegistry.PLAY, playHandler);
            }
            assert (playHandler != null);
            playHandler.handleBackendJoinGame(packet, this.serverConn);
            smc.setActiveSessionHandler(StateRegistry.PLAY, new BackendPlaySessionHandler(this.server, this.serverConn));
            this.serverConn.getPlayer().setConnectedServer(this.serverConn);
            smc.setAutoReading(true);
            if (smc.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_20_2) && player.getClientSettingsPacket() != null) {
                this.serverConn.ensureConnected().write(player.getClientSettingsPacket());
            }
            this.server.getEventManager().fireAndForget(new ServerPostConnectEvent(player, previousServer));
            this.resultFuture.complete(ConnectionRequestResults.successful(this.serverConn.getServer()));
        }, smc.eventLoop())).exceptionally(exc -> {
            logger.error("Unable to switch to new server {} for {}", (Object)this.serverConn.getServerInfo().getName(), (Object)player.getUsername(), exc);
            player.disconnect(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
            this.resultFuture.completeExceptionally((Throwable)exc);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(DisconnectPacket packet) {
        MinecraftConnection connection = this.serverConn.ensureConnected();
        this.serverConn.disconnect();
        if (connection.getType() == ConnectionTypes.LEGACY_FORGE && !this.serverConn.getPhase().consideredComplete()) {
            this.resultFuture.complete(ConnectionRequestResults.forUnsafeDisconnect(packet, this.serverConn.getServer()));
        } else {
            this.resultFuture.complete(ConnectionRequestResults.forDisconnect(packet, (RegisteredServer)this.serverConn.getServer()));
        }
        return true;
    }

    @Override
    public boolean handle(PluginMessagePacket packet) {
        if (this.bungeecordMessageResponder.process(packet)) {
            return true;
        }
        if (this.serverConn.getPhase().handle(this.serverConn, this.serverConn.getPlayer(), packet)) {
            VelocityServerConnection existingConnection;
            if (this.serverConn.getPhase() == LegacyForgeHandshakeBackendPhase.HELLO && (existingConnection = this.serverConn.getPlayer().getConnectedServer()) != null && existingConnection.getPhase() != BackendConnectionPhases.IN_TRANSITION) {
                existingConnection.setConnectionPhase(BackendConnectionPhases.IN_TRANSITION);
                existingConnection.getPhase().onDepartForNewServer(existingConnection, this.serverConn.getPlayer());
            }
            return true;
        }
        this.serverConn.getPlayer().getConnection().write(packet.retain());
        return true;
    }

    @Override
    public void disconnected() {
        this.resultFuture.completeExceptionally(new IOException("Unexpectedly disconnected from remote server"));
    }
}

