/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.util;

import com.google.common.io.ByteArrayDataInput;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;

public class ByteBufDataInput
implements ByteArrayDataInput {
    private final ByteBuf in;

    public ByteBufDataInput(ByteBuf buf) {
        this.in = buf;
    }

    public ByteBuf unwrap() {
        return this.in;
    }

    @Override
    public void readFully(byte[] b) {
        this.in.readBytes(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        this.in.readBytes(b, off, len);
    }

    @Override
    public int skipBytes(int n) {
        this.in.skipBytes(n);
        return n;
    }

    @Override
    public boolean readBoolean() {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() {
        return this.in.readUnsignedByte() & 0xFF;
    }

    @Override
    public short readShort() {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() {
        return this.in.readChar();
    }

    @Override
    public int readInt() {
        return this.in.readInt();
    }

    @Override
    public long readLong() {
        return this.in.readLong();
    }

    @Override
    public float readFloat() {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() {
        return this.in.readDouble();
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        try {
            return DataInputStream.readUTF(this);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

