/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.gson;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.gson.GsonVisitor;
import ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import ninja.leaping.configurate.loader.CommentHandler;
import ninja.leaping.configurate.loader.CommentHandlers;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GsonConfigurationLoader
extends AbstractConfigurationLoader<ConfigurationNode> {
    private final boolean lenient;
    private final String indent;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private GsonConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.DOUBLE_SLASH, CommentHandlers.SLASH_BLOCK, CommentHandlers.HASH});
        this.lenient = builder.isLenient();
        this.indent = Strings.repeat(" ", builder.getIndent());
    }

    @Override
    protected void loadInternal(ConfigurationNode node, BufferedReader reader) throws IOException {
        reader.mark(1);
        if (reader.read() == -1) {
            return;
        }
        reader.reset();
        try (JsonReader parser = new JsonReader(reader);){
            parser.setLenient(this.lenient);
            this.parseValue(parser, node);
        }
    }

    private void parseValue(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token = parser.peek();
        switch (token) {
            case BEGIN_OBJECT: {
                this.parseObject(parser, node);
                break;
            }
            case BEGIN_ARRAY: {
                this.parseArray(parser, node);
                break;
            }
            case NUMBER: {
                node.setValue(this.readNumber(parser));
                break;
            }
            case STRING: {
                node.setValue(parser.nextString());
                break;
            }
            case BOOLEAN: {
                node.setValue(parser.nextBoolean());
                break;
            }
            case NULL: {
                parser.nextNull();
                node.setValue(null);
                break;
            }
            case NAME: {
                break;
            }
            default: {
                throw new IOException("Unsupported token type: " + (Object)((Object)token));
            }
        }
    }

    private Number readNumber(JsonReader reader) throws IOException {
        String number = reader.nextString();
        if (number.contains(".")) {
            return Double.parseDouble(number);
        }
        long nextLong = Long.parseLong(number);
        int nextInt = (int)nextLong;
        if ((long)nextInt == nextLong) {
            return nextInt;
        }
        return nextLong;
    }

    private void parseArray(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginArray();
        boolean written = false;
        while ((token = parser.peek()) != null) {
            switch (token) {
                case END_ARRAY: {
                    parser.endArray();
                    return;
                }
            }
            this.parseValue(parser, node.appendListNode());
        }
        throw new JsonParseException("Reached end of stream with unclosed array at!");
    }

    private void parseObject(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginObject();
        boolean written = false;
        block4: while ((token = parser.peek()) != null) {
            switch (token) {
                case END_OBJECT: 
                case END_DOCUMENT: {
                    parser.endObject();
                    return;
                }
                case NAME: {
                    this.parseValue(parser, node.getNode(parser.nextName()));
                    continue block4;
                }
            }
            throw new JsonParseException("Received improper object value " + (Object)((Object)token));
        }
        throw new JsonParseException("Reached end of stream with unclosed object!");
    }

    @Override
    public void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        if (!this.lenient && !node.isMap()) {
            throw new IOException("Non-lenient json generators must have children of map type");
        }
        try (JsonWriter generator = new JsonWriter(writer);){
            generator.setIndent(this.indent);
            generator.setLenient(this.lenient);
            node.visit(GsonVisitor.INSTANCE.get(), generator);
            writer.write(SYSTEM_LINE_SEPARATOR);
        }
    }

    @Override
    public ConfigurationNode createEmptyNode(@NonNull ConfigurationOptions options) {
        options = options.withNativeTypes(ImmutableSet.of(Map.class, List.class, Double.class, Float.class, Long.class, Integer.class, new Class[]{Boolean.class, String.class}));
        return ConfigurationNode.root(options);
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private boolean lenient = true;
        private int indent = 2;

        protected Builder() {
        }

        public @NonNull Builder setIndent(int indent) {
            this.indent = indent;
            return this;
        }

        public int getIndent() {
            return this.indent;
        }

        public @NonNull Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public boolean isLenient() {
            return this.lenient;
        }

        public @NonNull GsonConfigurationLoader build() {
            return new GsonConfigurationLoader(this);
        }
    }
}

