/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.jni.zlib;

import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.md_5.bungee.jni.zlib.BungeeZlib;

public class JavaZlib
implements BungeeZlib {
    private final byte[] buffer = new byte[8192];
    private boolean compress;
    private Deflater deflater;
    private Inflater inflater;

    @Override
    public void init(boolean compress, int level) {
        this.compress = compress;
        this.free();
        if (compress) {
            this.deflater = new Deflater(level);
        } else {
            this.inflater = new Inflater();
        }
    }

    @Override
    public void free() {
        if (this.deflater != null) {
            this.deflater.end();
        }
        if (this.inflater != null) {
            this.inflater.end();
        }
    }

    @Override
    public void process(ByteBuf in, ByteBuf out) throws DataFormatException {
        byte[] inData = new byte[in.readableBytes()];
        in.readBytes(inData);
        if (this.compress) {
            this.deflater.setInput(inData);
            this.deflater.finish();
            while (!this.deflater.finished()) {
                int count = this.deflater.deflate(this.buffer);
                out.writeBytes(this.buffer, 0, count);
            }
            this.deflater.reset();
        } else {
            this.inflater.setInput(inData);
            while (!this.inflater.finished() && this.inflater.getTotalIn() < inData.length) {
                int count = this.inflater.inflate(this.buffer);
                out.writeBytes(this.buffer, 0, count);
            }
            this.inflater.reset();
        }
    }

    @Override
    public boolean allowComposite() {
        return true;
    }
}

