/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.function.Supplier;
import lombok.Generated;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.BundleDelimiter;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClearDialog;
import net.md_5.bungee.protocol.packet.ClearTitles;
import net.md_5.bungee.protocol.packet.ClientChat;
import net.md_5.bungee.protocol.packet.ClientChatAcknowledgement;
import net.md_5.bungee.protocol.packet.ClientCommand;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.Commands;
import net.md_5.bungee.protocol.packet.CookieRequest;
import net.md_5.bungee.protocol.packet.CookieResponse;
import net.md_5.bungee.protocol.packet.CustomClickAction;
import net.md_5.bungee.protocol.packet.DisconnectReportDetails;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.EntityStatus;
import net.md_5.bungee.protocol.packet.FinishConfiguration;
import net.md_5.bungee.protocol.packet.GameState;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginAcknowledged;
import net.md_5.bungee.protocol.packet.LoginPayloadRequest;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemRemove;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.ScoreboardScoreReset;
import net.md_5.bungee.protocol.packet.ServerData;
import net.md_5.bungee.protocol.packet.ServerLinks;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.ShowDialog;
import net.md_5.bungee.protocol.packet.ShowDialogDirect;
import net.md_5.bungee.protocol.packet.StartConfiguration;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.StoreCookie;
import net.md_5.bungee.protocol.packet.Subtitle;
import net.md_5.bungee.protocol.packet.SystemChat;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.Title;
import net.md_5.bungee.protocol.packet.TitleTimes;
import net.md_5.bungee.protocol.packet.Transfer;
import net.md_5.bungee.protocol.packet.UnsignedClientCommand;
import net.md_5.bungee.protocol.packet.ViewDistance;

public enum Protocol {
    HANDSHAKE{
        {
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)Handshake.class, (Supplier<? extends DefinedPacket>)Handshake::new, new ProtocolMapping[]{Protocol.map(47, 0)});
        }
    }
    ,
    GAME{
        {
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)BundleDelimiter.class, (Supplier<? extends DefinedPacket>)BundleDelimiter::new, new ProtocolMapping[]{Protocol.map(762, 0)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)KeepAlive.class, (Supplier<? extends DefinedPacket>)KeepAlive::new, new ProtocolMapping[]{Protocol.map(47, 0), Protocol.map(107, 31), Protocol.map(393, 33), Protocol.map(477, 32), Protocol.map(573, 33), Protocol.map(735, 32), Protocol.map(751, 31), Protocol.map(755, 33), Protocol.map(759, 30), Protocol.map(760, 32), Protocol.map(761, 31), Protocol.map(762, 35), Protocol.map(764, 36), Protocol.map(766, 38), Protocol.map(768, 39), Protocol.map(770, 38), Protocol.map(0x40000110, 43)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Login.class, (Supplier<? extends DefinedPacket>)Login::new, new ProtocolMapping[]{Protocol.map(47, 1), Protocol.map(107, 35), Protocol.map(393, 37), Protocol.map(573, 38), Protocol.map(735, 37), Protocol.map(751, 36), Protocol.map(755, 38), Protocol.map(759, 35), Protocol.map(760, 37), Protocol.map(761, 36), Protocol.map(762, 40), Protocol.map(764, 41), Protocol.map(766, 43), Protocol.map(768, 44), Protocol.map(770, 43), Protocol.map(0x40000110, 48)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Chat.class, (Supplier<? extends DefinedPacket>)Chat::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(47, 2), Protocol.map(107, 15), Protocol.map(393, 14), Protocol.map(573, 15), Protocol.map(735, 14), Protocol.map(755, 15), Protocol.map(759, -1)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Respawn.class, (Supplier<? extends DefinedPacket>)Respawn::new, new ProtocolMapping[]{Protocol.map(47, 7), Protocol.map(107, 51), Protocol.map(335, 52), Protocol.map(338, 53), Protocol.map(393, 56), Protocol.map(477, 58), Protocol.map(573, 59), Protocol.map(735, 58), Protocol.map(751, 57), Protocol.map(755, 61), Protocol.map(759, 59), Protocol.map(760, 62), Protocol.map(761, 61), Protocol.map(762, 65), Protocol.map(764, 67), Protocol.map(765, 69), Protocol.map(766, 71), Protocol.map(768, 76), Protocol.map(770, 75), Protocol.map(0x40000110, 80)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)BossBar.class, (Supplier<? extends DefinedPacket>)BossBar::new, new ProtocolMapping[]{Protocol.map(107, 12), Protocol.map(573, 13), Protocol.map(735, 12), Protocol.map(755, 13), Protocol.map(759, 10), Protocol.map(762, 11), Protocol.map(764, 10), Protocol.map(770, 9)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)PlayerListItem.class, (Supplier<? extends DefinedPacket>)PlayerListItem::new, new ProtocolMapping[]{Protocol.map(47, 56), Protocol.map(107, 45), Protocol.map(338, 46), Protocol.map(393, 48), Protocol.map(477, 51), Protocol.map(573, 52), Protocol.map(735, 51), Protocol.map(751, 50), Protocol.map(755, 54), Protocol.map(759, 52), Protocol.map(760, 55), Protocol.map(761, -1)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)TabCompleteResponse.class, (Supplier<? extends DefinedPacket>)TabCompleteResponse::new, new ProtocolMapping[]{Protocol.map(47, 58), Protocol.map(107, 14), Protocol.map(393, 16), Protocol.map(573, 17), Protocol.map(735, 16), Protocol.map(751, 15), Protocol.map(755, 17), Protocol.map(759, 14), Protocol.map(761, 13), Protocol.map(762, 15), Protocol.map(764, 16), Protocol.map(770, 15)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ScoreboardObjective.class, (Supplier<? extends DefinedPacket>)ScoreboardObjective::new, new ProtocolMapping[]{Protocol.map(47, 59), Protocol.map(107, 63), Protocol.map(335, 65), Protocol.map(338, 66), Protocol.map(393, 69), Protocol.map(477, 73), Protocol.map(573, 74), Protocol.map(755, 83), Protocol.map(760, 86), Protocol.map(761, 84), Protocol.map(762, 88), Protocol.map(764, 90), Protocol.map(765, 92), Protocol.map(766, 94), Protocol.map(768, 100), Protocol.map(770, 99), Protocol.map(0x40000110, 104)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ScoreboardScore.class, (Supplier<? extends DefinedPacket>)ScoreboardScore::new, new ProtocolMapping[]{Protocol.map(47, 60), Protocol.map(107, 66), Protocol.map(335, 68), Protocol.map(338, 69), Protocol.map(393, 72), Protocol.map(477, 76), Protocol.map(573, 77), Protocol.map(755, 86), Protocol.map(760, 89), Protocol.map(761, 87), Protocol.map(762, 91), Protocol.map(764, 93), Protocol.map(765, 95), Protocol.map(766, 97), Protocol.map(768, 104), Protocol.map(770, 103), Protocol.map(0x40000110, 108)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ScoreboardScoreReset.class, (Supplier<? extends DefinedPacket>)ScoreboardScoreReset::new, new ProtocolMapping[]{Protocol.map(765, 66), Protocol.map(766, 68), Protocol.map(768, 73), Protocol.map(770, 72), Protocol.map(0x40000110, 77)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ScoreboardDisplay.class, (Supplier<? extends DefinedPacket>)ScoreboardDisplay::new, new ProtocolMapping[]{Protocol.map(47, 61), Protocol.map(107, 56), Protocol.map(335, 58), Protocol.map(338, 59), Protocol.map(393, 62), Protocol.map(477, 66), Protocol.map(573, 67), Protocol.map(755, 76), Protocol.map(760, 79), Protocol.map(761, 77), Protocol.map(762, 81), Protocol.map(764, 83), Protocol.map(765, 85), Protocol.map(766, 87), Protocol.map(768, 92), Protocol.map(770, 91), Protocol.map(0x40000110, 96)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Team.class, (Supplier<? extends DefinedPacket>)Team::new, new ProtocolMapping[]{Protocol.map(47, 62), Protocol.map(107, 65), Protocol.map(335, 67), Protocol.map(338, 68), Protocol.map(393, 71), Protocol.map(477, 75), Protocol.map(573, 76), Protocol.map(755, 85), Protocol.map(760, 88), Protocol.map(761, 86), Protocol.map(762, 90), Protocol.map(764, 92), Protocol.map(765, 94), Protocol.map(766, 96), Protocol.map(768, 103), Protocol.map(770, 102), Protocol.map(0x40000110, 107)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)PluginMessage.class, (Supplier<? extends DefinedPacket>)PluginMessage::new, new ProtocolMapping[]{Protocol.map(47, 63), Protocol.map(107, 24), Protocol.map(393, 25), Protocol.map(477, 24), Protocol.map(573, 25), Protocol.map(735, 24), Protocol.map(751, 23), Protocol.map(755, 24), Protocol.map(759, 21), Protocol.map(760, 22), Protocol.map(761, 21), Protocol.map(762, 23), Protocol.map(764, 24), Protocol.map(766, 25), Protocol.map(770, 24)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Kick.class, (Supplier<? extends DefinedPacket>)Kick::new, new ProtocolMapping[]{Protocol.map(47, 64), Protocol.map(107, 26), Protocol.map(393, 27), Protocol.map(477, 26), Protocol.map(573, 27), Protocol.map(735, 26), Protocol.map(751, 25), Protocol.map(755, 26), Protocol.map(759, 23), Protocol.map(760, 25), Protocol.map(761, 23), Protocol.map(762, 26), Protocol.map(764, 27), Protocol.map(766, 29), Protocol.map(770, 28), Protocol.map(0x40000110, 32)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Title.class, (Supplier<? extends DefinedPacket>)Title::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(47, 69), Protocol.map(335, 71), Protocol.map(338, 72), Protocol.map(393, 75), Protocol.map(477, 79), Protocol.map(573, 80), Protocol.map(735, 79), Protocol.map(755, 89), Protocol.map(757, 90), Protocol.map(760, 93), Protocol.map(761, 91), Protocol.map(762, 95), Protocol.map(764, 97), Protocol.map(765, 99), Protocol.map(766, 101), Protocol.map(768, 108), Protocol.map(770, 107), Protocol.map(0x40000110, 112)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ClearTitles.class, (Supplier<? extends DefinedPacket>)ClearTitles::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(755, 16), Protocol.map(759, 13), Protocol.map(761, 12), Protocol.map(762, 14), Protocol.map(764, 15), Protocol.map(770, 14)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Subtitle.class, (Supplier<? extends DefinedPacket>)Subtitle::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(755, 87), Protocol.map(757, 88), Protocol.map(760, 91), Protocol.map(761, 89), Protocol.map(762, 93), Protocol.map(764, 95), Protocol.map(765, 97), Protocol.map(766, 99), Protocol.map(768, 106), Protocol.map(770, 105), Protocol.map(0x40000110, 110)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)TitleTimes.class, (Supplier<? extends DefinedPacket>)TitleTimes::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(755, 90), Protocol.map(757, 91), Protocol.map(760, 94), Protocol.map(761, 92), Protocol.map(762, 96), Protocol.map(764, 98), Protocol.map(765, 100), Protocol.map(766, 102), Protocol.map(768, 109), Protocol.map(770, 108), Protocol.map(0x40000110, 113)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)SystemChat.class, (Supplier<? extends DefinedPacket>)SystemChat::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(759, 95), Protocol.map(760, 98), Protocol.map(761, 96), Protocol.map(762, 100), Protocol.map(764, 103), Protocol.map(765, 105), Protocol.map(766, 108), Protocol.map(768, 115), Protocol.map(770, 114), Protocol.map(0x40000110, 119)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)PlayerListHeaderFooter.class, (Supplier<? extends DefinedPacket>)PlayerListHeaderFooter::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(47, 71), Protocol.map(107, 72), Protocol.map(110, 71), Protocol.map(335, 73), Protocol.map(338, 74), Protocol.map(393, 78), Protocol.map(477, 83), Protocol.map(573, 84), Protocol.map(735, 83), Protocol.map(755, 94), Protocol.map(757, 95), Protocol.map(759, 96), Protocol.map(760, 99), Protocol.map(761, 97), Protocol.map(762, 101), Protocol.map(764, 104), Protocol.map(765, 106), Protocol.map(766, 109), Protocol.map(768, 116), Protocol.map(770, 115), Protocol.map(0x40000110, 120)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)EntityStatus.class, (Supplier<? extends DefinedPacket>)EntityStatus::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(47, 26), Protocol.map(107, 27), Protocol.map(393, 28), Protocol.map(477, 27), Protocol.map(573, 28), Protocol.map(735, 27), Protocol.map(751, 26), Protocol.map(755, 27), Protocol.map(759, 24), Protocol.map(760, 26), Protocol.map(761, 25), Protocol.map(762, 28), Protocol.map(764, 29), Protocol.map(766, 31), Protocol.map(770, 30), Protocol.map(0x40000110, 34)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Commands.class, (Supplier<? extends DefinedPacket>)Commands::new, new ProtocolMapping[]{Protocol.map(393, 17), Protocol.map(573, 18), Protocol.map(735, 17), Protocol.map(751, 16), Protocol.map(755, 18), Protocol.map(759, 15), Protocol.map(761, 14), Protocol.map(762, 16), Protocol.map(764, 17), Protocol.map(770, 16)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)GameState.class, (Supplier<? extends DefinedPacket>)GameState::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(573, 31), Protocol.map(735, 30), Protocol.map(751, 29), Protocol.map(755, 30), Protocol.map(759, 27), Protocol.map(760, 29), Protocol.map(761, 28), Protocol.map(762, 31), Protocol.map(764, 32), Protocol.map(766, 34), Protocol.map(768, 35), Protocol.map(770, 34), Protocol.map(0x40000110, 38)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ViewDistance.class, (Supplier<? extends DefinedPacket>)ViewDistance::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(477, 65), Protocol.map(573, 66), Protocol.map(735, 65), Protocol.map(755, 74), Protocol.map(759, 73), Protocol.map(760, 76), Protocol.map(761, 75), Protocol.map(762, 79), Protocol.map(764, 81), Protocol.map(765, 83), Protocol.map(766, 85), Protocol.map(768, 89), Protocol.map(770, 88), Protocol.map(0x40000110, 93)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ServerData.class, (Supplier<? extends DefinedPacket>)ServerData::new, new ProtocolMapping[]{Protocol.map(759, 63), Protocol.map(760, 66), Protocol.map(761, 65), Protocol.map(762, 69), Protocol.map(764, 71), Protocol.map(765, 73), Protocol.map(766, 75), Protocol.map(768, 80), Protocol.map(770, 79), Protocol.map(0x40000110, 84)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)PlayerListItemRemove.class, (Supplier<? extends DefinedPacket>)PlayerListItemRemove::new, new ProtocolMapping[]{Protocol.map(761, 53), Protocol.map(762, 57), Protocol.map(764, 59), Protocol.map(766, 61), Protocol.map(768, 63), Protocol.map(770, 62), Protocol.map(0x40000110, 67)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)PlayerListItemUpdate.class, (Supplier<? extends DefinedPacket>)PlayerListItemUpdate::new, new ProtocolMapping[]{Protocol.map(761, 54), Protocol.map(762, 58), Protocol.map(764, 60), Protocol.map(766, 62), Protocol.map(768, 64), Protocol.map(770, 63), Protocol.map(0x40000110, 68)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)StartConfiguration.class, (Supplier<? extends DefinedPacket>)StartConfiguration::new, new ProtocolMapping[]{Protocol.map(764, 101), Protocol.map(765, 103), Protocol.map(766, 105), Protocol.map(768, 112), Protocol.map(770, 111), Protocol.map(0x40000110, 116)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)CookieRequest.class, (Supplier<? extends DefinedPacket>)CookieRequest::new, new ProtocolMapping[]{Protocol.map(766, 22), Protocol.map(770, 21)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)StoreCookie.class, (Supplier<? extends DefinedPacket>)StoreCookie::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(766, 107), Protocol.map(768, 114), Protocol.map(770, 113), Protocol.map(0x40000110, 118)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Transfer.class, (Supplier<? extends DefinedPacket>)Transfer::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(766, 115), Protocol.map(768, 122), Protocol.map(0x40000110, 127)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)DisconnectReportDetails.class, (Supplier<? extends DefinedPacket>)DisconnectReportDetails::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(767, 122), Protocol.map(768, 129), Protocol.map(0x40000110, 134)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ServerLinks.class, (Supplier<? extends DefinedPacket>)ServerLinks::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(767, 123), Protocol.map(768, 130), Protocol.map(0x40000110, 135)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ClearDialog.class, (Supplier<? extends DefinedPacket>)ClearDialog::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(771, 132), Protocol.map(0x40000110, 137)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ShowDialog.class, (Supplier<? extends DefinedPacket>)ShowDialog::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(771, 133), Protocol.map(0x40000110, 138)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)KeepAlive.class, (Supplier<? extends DefinedPacket>)KeepAlive::new, new ProtocolMapping[]{Protocol.map(47, 0), Protocol.map(107, 11), Protocol.map(335, 12), Protocol.map(338, 11), Protocol.map(393, 14), Protocol.map(477, 15), Protocol.map(735, 16), Protocol.map(755, 15), Protocol.map(759, 17), Protocol.map(760, 18), Protocol.map(761, 17), Protocol.map(762, 18), Protocol.map(764, 20), Protocol.map(765, 21), Protocol.map(766, 24), Protocol.map(768, 26), Protocol.map(771, 27)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)Chat.class, (Supplier<? extends DefinedPacket>)Chat::new, new ProtocolMapping[]{Protocol.map(47, 1), Protocol.map(107, 2), Protocol.map(335, 3), Protocol.map(338, 2), Protocol.map(477, 3), Protocol.map(759, -1)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)ClientCommand.class, (Supplier<? extends DefinedPacket>)ClientCommand::new, new ProtocolMapping[]{Protocol.map(759, 3), Protocol.map(760, 4), Protocol.map(766, 5), Protocol.map(768, 6), Protocol.map(771, 7)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)UnsignedClientCommand.class, (Supplier<? extends DefinedPacket>)UnsignedClientCommand::new, new ProtocolMapping[]{Protocol.map(766, 4), Protocol.map(768, 5), Protocol.map(771, 6)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)ClientChat.class, (Supplier<? extends DefinedPacket>)ClientChat::new, new ProtocolMapping[]{Protocol.map(759, 4), Protocol.map(760, 5), Protocol.map(766, 6), Protocol.map(768, 7), Protocol.map(771, 8)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)ClientChatAcknowledgement.class, (Supplier<? extends DefinedPacket>)ClientChatAcknowledgement::new, new ProtocolMapping[]{Protocol.map(761, 3)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)TabCompleteRequest.class, (Supplier<? extends DefinedPacket>)TabCompleteRequest::new, new ProtocolMapping[]{Protocol.map(47, 20), Protocol.map(107, 1), Protocol.map(335, 2), Protocol.map(338, 1), Protocol.map(393, 5), Protocol.map(477, 6), Protocol.map(759, 8), Protocol.map(760, 9), Protocol.map(761, 8), Protocol.map(762, 9), Protocol.map(764, 10), Protocol.map(766, 11), Protocol.map(768, 13), Protocol.map(771, 14)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)ClientSettings.class, (Supplier<? extends DefinedPacket>)ClientSettings::new, new ProtocolMapping[]{Protocol.map(47, 21), Protocol.map(107, 4), Protocol.map(335, 5), Protocol.map(338, 4), Protocol.map(477, 5), Protocol.map(759, 7), Protocol.map(760, 8), Protocol.map(761, 7), Protocol.map(762, 8), Protocol.map(764, 9), Protocol.map(766, 10), Protocol.map(768, 12), Protocol.map(771, 13)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)PluginMessage.class, (Supplier<? extends DefinedPacket>)PluginMessage::new, new ProtocolMapping[]{Protocol.map(47, 23), Protocol.map(107, 9), Protocol.map(335, 10), Protocol.map(338, 9), Protocol.map(393, 10), Protocol.map(477, 11), Protocol.map(755, 10), Protocol.map(759, 12), Protocol.map(760, 13), Protocol.map(761, 12), Protocol.map(762, 13), Protocol.map(764, 15), Protocol.map(765, 16), Protocol.map(766, 18), Protocol.map(768, 20), Protocol.map(771, 21)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)StartConfiguration.class, (Supplier<? extends DefinedPacket>)StartConfiguration::new, new ProtocolMapping[]{Protocol.map(764, 11), Protocol.map(766, 12), Protocol.map(768, 14), Protocol.map(771, 15)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)CookieResponse.class, (Supplier<? extends DefinedPacket>)CookieResponse::new, new ProtocolMapping[]{Protocol.map(766, 17), Protocol.map(768, 19), Protocol.map(771, 20)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)CustomClickAction.class, (Supplier<? extends DefinedPacket>)CustomClickAction::new, new ProtocolMapping[]{Protocol.map(771, 65)});
        }
    }
    ,
    STATUS{
        {
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)StatusResponse.class, (Supplier<? extends DefinedPacket>)StatusResponse::new, new ProtocolMapping[]{Protocol.map(47, 0)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)PingPacket.class, (Supplier<? extends DefinedPacket>)PingPacket::new, new ProtocolMapping[]{Protocol.map(47, 1)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)StatusRequest.class, (Supplier<? extends DefinedPacket>)StatusRequest::new, new ProtocolMapping[]{Protocol.map(47, 0)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)PingPacket.class, (Supplier<? extends DefinedPacket>)PingPacket::new, new ProtocolMapping[]{Protocol.map(47, 1)});
        }
    }
    ,
    LOGIN{
        {
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Kick.class, (Supplier<? extends DefinedPacket>)Kick::new, new ProtocolMapping[]{Protocol.map(47, 0)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)EncryptionRequest.class, (Supplier<? extends DefinedPacket>)EncryptionRequest::new, new ProtocolMapping[]{Protocol.map(47, 1)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)LoginSuccess.class, (Supplier<? extends DefinedPacket>)LoginSuccess::new, new ProtocolMapping[]{Protocol.map(47, 2)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)SetCompression.class, (Supplier<? extends DefinedPacket>)SetCompression::new, new ProtocolMapping[]{Protocol.map(47, 3)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)LoginPayloadRequest.class, (Supplier<? extends DefinedPacket>)LoginPayloadRequest::new, new ProtocolMapping[]{Protocol.map(393, 4)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)CookieRequest.class, (Supplier<? extends DefinedPacket>)CookieRequest::new, new ProtocolMapping[]{Protocol.map(766, 5)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)LoginRequest.class, (Supplier<? extends DefinedPacket>)LoginRequest::new, new ProtocolMapping[]{Protocol.map(47, 0)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)EncryptionResponse.class, (Supplier<? extends DefinedPacket>)EncryptionResponse::new, new ProtocolMapping[]{Protocol.map(47, 1)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)LoginPayloadResponse.class, (Supplier<? extends DefinedPacket>)LoginPayloadResponse::new, new ProtocolMapping[]{Protocol.map(393, 2)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)LoginAcknowledged.class, (Supplier<? extends DefinedPacket>)LoginAcknowledged::new, new ProtocolMapping[]{Protocol.map(764, 3)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)CookieResponse.class, (Supplier<? extends DefinedPacket>)CookieResponse::new, new ProtocolMapping[]{Protocol.map(766, 4)});
        }
    }
    ,
    CONFIGURATION{
        {
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)CookieRequest.class, (Supplier<? extends DefinedPacket>)CookieRequest::new, new ProtocolMapping[]{Protocol.map(766, 0)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)PluginMessage.class, (Supplier<? extends DefinedPacket>)PluginMessage::new, new ProtocolMapping[]{Protocol.map(764, 0), Protocol.map(766, 1)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Kick.class, (Supplier<? extends DefinedPacket>)Kick::new, new ProtocolMapping[]{Protocol.map(764, 1), Protocol.map(766, 2)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)FinishConfiguration.class, (Supplier<? extends DefinedPacket>)FinishConfiguration::new, new ProtocolMapping[]{Protocol.map(764, 2), Protocol.map(766, 3)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)KeepAlive.class, (Supplier<? extends DefinedPacket>)KeepAlive::new, new ProtocolMapping[]{Protocol.map(764, 3), Protocol.map(766, 4)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)StoreCookie.class, (Supplier<? extends DefinedPacket>)StoreCookie::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(766, 10)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)Transfer.class, (Supplier<? extends DefinedPacket>)Transfer::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(766, 11)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)DisconnectReportDetails.class, (Supplier<? extends DefinedPacket>)DisconnectReportDetails::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(767, 15)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ServerLinks.class, (Supplier<? extends DefinedPacket>)ServerLinks::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(767, 16)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ClearDialog.class, (Supplier<? extends DefinedPacket>)ClearDialog::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(771, 17)});
            this.TO_CLIENT.registerPacket((Class<? extends DefinedPacket>)ShowDialogDirect.class, (Supplier<? extends DefinedPacket>)ShowDialogDirect::new, RegisterType.ENCODE, new ProtocolMapping[]{Protocol.map(771, 18)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)ClientSettings.class, (Supplier<? extends DefinedPacket>)ClientSettings::new, new ProtocolMapping[]{Protocol.map(764, 0)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)PluginMessage.class, (Supplier<? extends DefinedPacket>)PluginMessage::new, new ProtocolMapping[]{Protocol.map(764, 1), Protocol.map(766, 2)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)FinishConfiguration.class, (Supplier<? extends DefinedPacket>)FinishConfiguration::new, new ProtocolMapping[]{Protocol.map(764, 2), Protocol.map(766, 3)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)KeepAlive.class, (Supplier<? extends DefinedPacket>)KeepAlive::new, new ProtocolMapping[]{Protocol.map(764, 3), Protocol.map(766, 4)});
            this.TO_SERVER.registerPacket((Class<? extends DefinedPacket>)CustomClickAction.class, (Supplier<? extends DefinedPacket>)CustomClickAction::new, new ProtocolMapping[]{Protocol.map(771, 8)});
        }
    };

    public static final int MAX_PACKET_ID = 255;
    public final DirectionData TO_SERVER = new DirectionData(this, ProtocolConstants.Direction.TO_SERVER);
    public final DirectionData TO_CLIENT = new DirectionData(this, ProtocolConstants.Direction.TO_CLIENT);

    public static void main(String[] args) {
        for (int version : ProtocolConstants.SUPPORTED_VERSION_IDS) {
            Protocol.dump(version);
        }
    }

    private static void dump(int version) {
        for (Protocol protocol : Protocol.values()) {
            Protocol.dump(version, protocol);
        }
    }

    private static void dump(int version, Protocol protocol) {
        Protocol.dump(version, protocol.TO_CLIENT);
        Protocol.dump(version, protocol.TO_SERVER);
    }

    private static void dump(int version, DirectionData data) {
        for (int id = 0; id < 255; ++id) {
            DefinedPacket packet = data.createPacket(id, version);
            if (packet == null) continue;
            System.out.println(version + " " + (Object)((Object)data.protocolPhase) + " " + (Object)((Object)data.direction) + " " + id + " " + packet.getClass().getSimpleName());
        }
    }

    private static ProtocolMapping map(int protocol, int id) {
        return new ProtocolMapping(protocol, id);
    }

    private static class ProtocolMapping {
        private final int protocolVersion;
        private final int packetID;

        @Generated
        public ProtocolMapping(int protocolVersion, int packetID) {
            this.protocolVersion = protocolVersion;
            this.packetID = packetID;
        }

        @Generated
        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        @Generated
        public int getPacketID() {
            return this.packetID;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProtocolMapping)) {
                return false;
            }
            ProtocolMapping other = (ProtocolMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProtocolVersion() != other.getProtocolVersion()) {
                return false;
            }
            return this.getPacketID() == other.getPacketID();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProtocolMapping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProtocolVersion();
            result = result * 59 + this.getPacketID();
            return result;
        }

        @Generated
        public String toString() {
            return "Protocol.ProtocolMapping(protocolVersion=" + this.getProtocolVersion() + ", packetID=" + this.getPacketID() + ")";
        }
    }

    public static final class DirectionData {
        private final Int2ObjectMap<ProtocolData> protocols = new Int2ObjectOpenHashMap<ProtocolData>();
        private final Protocol protocolPhase;
        private final ProtocolConstants.Direction direction;

        public DirectionData(Protocol protocolPhase, ProtocolConstants.Direction direction) {
            this.protocolPhase = protocolPhase;
            this.direction = direction;
            for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS) {
                this.protocols.put(protocol, new ProtocolData(protocol));
            }
        }

        private ProtocolData getProtocolData(int version) {
            ProtocolData protocol = (ProtocolData)this.protocols.get(version);
            if (protocol == null && this.protocolPhase != GAME) {
                protocol = Iterables.getFirst(this.protocols.values(), null);
            }
            return protocol;
        }

        public boolean hasPacket(int i, boolean supportsForge) {
            return supportsForge || i >= 0 && i <= 255;
        }

        public final DefinedPacket createPacket(int id, int version) {
            return this.createPacket(id, version, true);
        }

        public final DefinedPacket createPacket(int id, int version, boolean supportsForge) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version " + version);
            }
            if (!this.hasPacket(id, supportsForge)) {
                throw new BadPacketException("Packet with id " + id + " outside of range");
            }
            Supplier constructor = protocolData.packetConstructors[id];
            return constructor == null ? null : (DefinedPacket)constructor.get();
        }

        private void registerPacket(Class<? extends DefinedPacket> packetClass, Supplier<? extends DefinedPacket> constructor, ProtocolMapping ... mappings) {
            this.registerPacket(packetClass, constructor, RegisterType.BOTH, mappings);
        }

        private void registerPacket(Class<? extends DefinedPacket> packetClass, Supplier<? extends DefinedPacket> constructor, RegisterType registerType, ProtocolMapping ... mappings) {
            int mappingIndex = 0;
            ProtocolMapping mapping = mappings[mappingIndex];
            for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS) {
                ProtocolMapping nextMapping;
                if (protocol < mapping.protocolVersion) continue;
                if (mapping.protocolVersion < protocol && mappingIndex + 1 < mappings.length && (nextMapping = mappings[mappingIndex + 1]).protocolVersion == protocol) {
                    Preconditions.checkState(nextMapping.packetID != mapping.packetID, "Duplicate packet mapping (%s, %s)", mapping.protocolVersion, nextMapping.protocolVersion);
                    mapping = nextMapping;
                    ++mappingIndex;
                }
                if (mapping.packetID < 0) break;
                ProtocolData data = (ProtocolData)this.protocols.get(protocol);
                Preconditions.checkState(data.packetConstructors[mapping.packetID] == null, "Duplicate packet mapping (%s)", mapping.packetID);
                Preconditions.checkState(!data.packetMap.containsKey(packetClass), "Duplicate packet mapping (%s)", mapping.packetID);
                if (registerType.encode()) {
                    data.packetMap.put(packetClass, mapping.packetID);
                }
                if (!registerType.decode()) continue;
                ((ProtocolData)data).packetConstructors[((ProtocolMapping)mapping).packetID] = constructor;
            }
        }

        public boolean hasPacket(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            return protocolData.packetMap.containsKey(packet);
        }

        final int getId(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            int packetId = protocolData.packetMap.get(packet);
            Preconditions.checkArgument(packetId >= 0, "Cannot get ID for packet %s in phase %s with direction %s for protocol version %s", packet, (Object)this.protocolPhase, (Object)this.direction, (Object)version);
            return packetId;
        }

        @Generated
        public ProtocolConstants.Direction getDirection() {
            return this.direction;
        }
    }

    private static enum RegisterType {
        ENCODE,
        DECODE,
        BOTH;


        public boolean encode() {
            return this == BOTH || this == ENCODE;
        }

        public boolean decode() {
            return this == BOTH || this == DECODE;
        }
    }

    private static class ProtocolData {
        private final int protocolVersion;
        private final Object2IntMap<Class<? extends DefinedPacket>> packetMap = new Object2IntOpenHashMap<Class<? extends DefinedPacket>>(255);
        private final Supplier<? extends DefinedPacket>[] packetConstructors = new Supplier[255];

        @Generated
        public ProtocolData(int protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @Generated
        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        @Generated
        public Object2IntMap<Class<? extends DefinedPacket>> getPacketMap() {
            return this.packetMap;
        }

        @Generated
        public Supplier<? extends DefinedPacket>[] getPacketConstructors() {
            return this.packetConstructors;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProtocolData)) {
                return false;
            }
            ProtocolData other = (ProtocolData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProtocolVersion() != other.getProtocolVersion()) {
                return false;
            }
            Object2IntMap<Class<? extends DefinedPacket>> this$packetMap = this.getPacketMap();
            Object2IntMap<Class<? extends DefinedPacket>> other$packetMap = other.getPacketMap();
            if (this$packetMap == null ? other$packetMap != null : !this$packetMap.equals(other$packetMap)) {
                return false;
            }
            return Arrays.deepEquals(this.getPacketConstructors(), other.getPacketConstructors());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProtocolData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProtocolVersion();
            Object2IntMap<Class<? extends DefinedPacket>> $packetMap = this.getPacketMap();
            result = result * 59 + ($packetMap == null ? 43 : $packetMap.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPacketConstructors());
            return result;
        }

        @Generated
        public String toString() {
            return "Protocol.ProtocolData(protocolVersion=" + this.getProtocolVersion() + ", packetMap=" + this.getPacketMap() + ", packetConstructors=" + Arrays.deepToString(this.getPacketConstructors()) + ")";
        }
    }
}

