/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.util.Favicon;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.Nullable;

public class ServerDataPacket
implements MinecraftPacket {
    @Nullable
    private ComponentHolder description;
    @Nullable
    private Favicon favicon;
    private boolean secureChatEnforced;

    public ServerDataPacket() {
    }

    public ServerDataPacket(@Nullable ComponentHolder description, @Nullable Favicon favicon, boolean secureChatEnforced) {
        this.description = description;
        this.favicon = favicon;
        this.secureChatEnforced = secureChatEnforced;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_19_4) || buf.readBoolean()) {
            this.description = ComponentHolder.read(buf, protocolVersion);
        }
        if (buf.readBoolean()) {
            Object iconBase64;
            if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_19_4)) {
                byte[] iconBytes = ProtocolUtils.readByteArray(buf);
                iconBase64 = "data:image/png;base64," + new String(Base64.getEncoder().encode(iconBytes), StandardCharsets.UTF_8);
            } else {
                iconBase64 = ProtocolUtils.readString(buf);
            }
            this.favicon = new Favicon((String)iconBase64);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
            buf.readBoolean();
        }
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_19_1) && protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            this.secureChatEnforced = buf.readBoolean();
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        boolean hasDescription;
        boolean bl = hasDescription = this.description != null;
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_19_4)) {
            buf.writeBoolean(hasDescription);
        }
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_19_4) || hasDescription) {
            this.description.write(buf);
        }
        boolean hasFavicon = this.favicon != null;
        buf.writeBoolean(hasFavicon);
        if (hasFavicon) {
            if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_19_4)) {
                String cutIconBase64 = this.favicon.getBase64Url().substring("data:image/png;base64,".length());
                byte[] iconBytes = Base64.getDecoder().decode(cutIconBase64.getBytes(StandardCharsets.UTF_8));
                ProtocolUtils.writeByteArray(buf, iconBytes);
            } else {
                ProtocolUtils.writeString(buf, this.favicon.getBase64Url());
            }
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
            buf.writeBoolean(false);
        }
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_19_1) && protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            buf.writeBoolean(this.secureChatEnforced);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    @Nullable
    public ComponentHolder getDescription() {
        return this.description;
    }

    @Nullable
    public Favicon getFavicon() {
        return this.favicon;
    }

    public boolean isSecureChatEnforced() {
        return this.secureChatEnforced;
    }

    public void setSecureChatEnforced(boolean secureChatEnforced) {
        this.secureChatEnforced = secureChatEnforced;
    }

    @Override
    public int encodeSizeHint(ProtocolUtils.Direction direction, ProtocolVersion version) {
        return 8192;
    }
}

