/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.translation;

import java.util.Objects;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.TranslationArgumentLike;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorArgument;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorTarget;
import org.jetbrains.annotations.NotNull;

public final class Argument {
    private Argument() {
    }

    @NotNull
    public static ComponentLike bool(@TagPattern @NotNull String name, boolean value) {
        return Argument.argument(name, TranslationArgument.bool(value));
    }

    @NotNull
    public static ComponentLike numeric(@TagPattern @NotNull String name, @NotNull Number value) {
        return Argument.argument(name, TranslationArgument.numeric(value));
    }

    @Deprecated
    @NotNull
    public static ComponentLike numeric(@TagPattern @NotNull String name, @NotNull String value) {
        return Argument.string(name, value);
    }

    @NotNull
    public static ComponentLike string(@TagPattern @NotNull String name, @NotNull String value) {
        return Argument.argument(name, TranslationArgument.component(Component.text(value)));
    }

    @NotNull
    public static ComponentLike component(@TagPattern @NotNull String name, @NotNull ComponentLike value) {
        return Argument.argument(name, TranslationArgument.component(value));
    }

    @NotNull
    public static ComponentLike argument(@TagPattern @NotNull String name, @NotNull TranslationArgumentLike argument) {
        return Argument.argument(name, Objects.requireNonNull(argument, "argument").asTranslationArgument());
    }

    @NotNull
    public static ComponentLike argument(@TagPattern @NotNull String name, @NotNull TranslationArgument argument) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<TranslationArgument>(name, Objects.requireNonNull(argument, "argument")));
    }

    @NotNull
    public static ComponentLike tag(@TagPattern @NotNull String name, @NotNull Tag tag) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<Tag>(name, Objects.requireNonNull(tag, "tag")));
    }

    @NotNull
    public static ComponentLike tagResolver(TagResolver ... resolvers) {
        return Argument.tagResolver(TagResolver.resolver(resolvers));
    }

    @NotNull
    public static ComponentLike tagResolver(@NotNull Iterable<TagResolver> resolvers) {
        return Argument.tagResolver(TagResolver.resolver(resolvers));
    }

    @NotNull
    public static ComponentLike tagResolver(@NotNull TagResolver tagResolver) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<TagResolver>("unused", Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    @NotNull
    public static ComponentLike target(@NotNull Pointered target) {
        return Component.virtual(Void.class, new MiniMessageTranslatorTarget(Objects.requireNonNull(target, "target")));
    }
}

