/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.util.VelocityInboundConnection;
import com.velocitypowered.proxy.protocol.packet.LegacyDisconnect;
import com.velocitypowered.proxy.protocol.packet.LegacyPingPacket;
import com.velocitypowered.proxy.protocol.packet.StatusPingPacket;
import com.velocitypowered.proxy.protocol.packet.StatusRequestPacket;
import com.velocitypowered.proxy.protocol.packet.StatusResponsePacket;
import com.velocitypowered.proxy.util.except.QuietRuntimeException;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatusSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(StatusSessionHandler.class);
    private static final QuietRuntimeException EXPECTED_AWAITING_REQUEST = new QuietRuntimeException("Expected connection to be awaiting status request");
    private final VelocityServer server;
    private final MinecraftConnection connection;
    private final VelocityInboundConnection inbound;
    private boolean pingReceived = false;

    StatusSessionHandler(VelocityServer server, VelocityInboundConnection inbound) {
        this.server = server;
        this.connection = inbound.getConnection();
        this.inbound = inbound;
    }

    @Override
    public void activated() {
        if (this.server.getConfiguration().isShowPingRequests()) {
            logger.info("{} is pinging the server with version {}", (Object)this.inbound, (Object)this.connection.getProtocolVersion());
        }
    }

    @Override
    public boolean handle(LegacyPingPacket packet) {
        if (this.pingReceived) {
            throw EXPECTED_AWAITING_REQUEST;
        }
        this.pingReceived = true;
        ((CompletableFuture)((CompletableFuture)this.server.getServerListPingHandler().getInitialPing(this.inbound).thenCompose(ping -> this.server.getEventManager().fire(new ProxyPingEvent(this.inbound, (ServerPing)ping)))).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                this.connection.closeWith(LegacyDisconnect.fromServerPing(event.getPing(), packet.getVersion()));
            } else {
                this.connection.close();
            }
        }, (Executor)this.connection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling legacy ping {}", (Object)packet, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(StatusPingPacket packet) {
        this.connection.closeWith(packet);
        return true;
    }

    @Override
    public boolean handle(StatusRequestPacket packet) {
        if (this.pingReceived) {
            throw EXPECTED_AWAITING_REQUEST;
        }
        this.pingReceived = true;
        ((CompletableFuture)((CompletableFuture)this.server.getServerListPingHandler().getInitialPing(this.inbound).thenCompose(ping -> this.server.getEventManager().fire(new ProxyPingEvent(this.inbound, (ServerPing)ping)))).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                StringBuilder json = new StringBuilder();
                VelocityServer.getPingGsonInstance(this.connection.getProtocolVersion()).toJson((Object)event.getPing(), (Appendable)json);
                this.connection.write(new StatusResponsePacket(json));
            } else {
                this.connection.close();
            }
        }, (Executor)this.connection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling status request {}", (Object)packet, ex);
            return null;
        });
        return true;
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.connection.close(true);
    }

    private static enum State {
        AWAITING_REQUEST,
        RECEIVED_REQUEST;

    }
}

