/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.util;

import com.google.common.collect.ImmutableList;
import com.spotify.futures.CompletableFutures;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.server.PingOptions;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.api.util.ModInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PingPassthroughMode;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.util.VelocityInboundConnection;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;

public class ServerListPingHandler {
    private final VelocityServer server;

    public ServerListPingHandler(VelocityServer server) {
        this.server = server;
    }

    private ServerPing constructLocalPing(ProtocolVersion version) {
        List<ServerPing.SamplePlayer> samplePlayers;
        VelocityConfiguration configuration;
        if (version == ProtocolVersion.UNKNOWN) {
            version = ProtocolVersion.MAXIMUM_VERSION;
        }
        if ((configuration = this.server.getConfiguration()).getSamplePlayersInPing()) {
            List unshuffledPlayers = this.server.getAllPlayers().stream().map(p -> {
                if (p.getPlayerSettings().isClientListingAllowed()) {
                    return new ServerPing.SamplePlayer(p.getUsername(), p.getUniqueId());
                }
                return ServerPing.SamplePlayer.ANONYMOUS;
            }).collect(Collectors.toList());
            Collections.shuffle(unshuffledPlayers);
            samplePlayers = unshuffledPlayers.subList(0, Math.min(12, this.server.getPlayerCount()));
        } else {
            samplePlayers = ImmutableList.of();
        }
        return new ServerPing(new ServerPing.Version(version.getProtocol(), "Velocity " + ProtocolVersion.SUPPORTED_VERSION_STRING), new ServerPing.Players(this.server.getPlayerCount(), configuration.getShowMaxPlayers(), samplePlayers), configuration.getMotd(), configuration.getFavicon().orElse(null), configuration.isAnnounceForge() ? ModInfo.DEFAULT : null);
    }

    private CompletableFuture<ServerPing> attemptPingPassthrough(VelocityInboundConnection connection, PingPassthroughMode mode, List<String> servers, ProtocolVersion responseProtocolVersion, String virtualHostStr) {
        ServerPing fallback = this.constructLocalPing(connection.getProtocolVersion());
        ArrayList<CompletableFuture<ServerPing>> pings = new ArrayList<CompletableFuture<ServerPing>>();
        for (String s : servers) {
            Optional<RegisteredServer> rs = this.server.getServer(s);
            if (rs.isEmpty()) continue;
            VelocityRegisteredServer vrs = (VelocityRegisteredServer)rs.get();
            pings.add(vrs.ping(connection.getConnection().eventLoop(), PingOptions.builder().version(responseProtocolVersion).virtualHost(virtualHostStr).build()));
        }
        if (pings.isEmpty()) {
            return CompletableFuture.completedFuture(fallback);
        }
        CompletableFuture<List<ServerPing>> pingResponses = CompletableFutures.successfulAsList(pings, ex -> fallback);
        return switch (mode) {
            case PingPassthroughMode.ALL -> pingResponses.thenApply(responses -> {
                for (ServerPing response : responses) {
                    if (response == fallback) continue;
                    if (response.getDescriptionComponent() == null) {
                        return response.asBuilder().description(Component.empty()).build();
                    }
                    return response;
                }
                return fallback;
            });
            case PingPassthroughMode.MODS -> pingResponses.thenApply(responses -> {
                for (ServerPing response : responses) {
                    Optional<ModInfo> modInfo;
                    if (response == fallback || !(modInfo = response.getModinfo()).isPresent()) continue;
                    return fallback.asBuilder().mods(modInfo.get()).build();
                }
                return fallback;
            });
            case PingPassthroughMode.DESCRIPTION -> pingResponses.thenApply(responses -> {
                for (ServerPing response : responses) {
                    if (response == fallback || response.getDescriptionComponent() == null) continue;
                    return new ServerPing(fallback.getVersion(), fallback.getPlayers().orElse(null), response.getDescriptionComponent(), fallback.getFavicon().orElse(null), response.getModinfo().orElse(null));
                }
                return fallback;
            });
            default -> CompletableFuture.completedFuture(fallback);
        };
    }

    public CompletableFuture<ServerPing> getInitialPing(VelocityInboundConnection connection) {
        VelocityConfiguration configuration = this.server.getConfiguration();
        ProtocolVersion shownVersion = connection.getProtocolVersion().isSupported() ? connection.getProtocolVersion() : ProtocolVersion.MAXIMUM_VERSION;
        PingPassthroughMode passthroughMode = configuration.getPingPassthrough();
        if (passthroughMode == PingPassthroughMode.DISABLED) {
            return CompletableFuture.completedFuture(this.constructLocalPing(shownVersion));
        }
        String virtualHostStr = connection.getVirtualHost().map(InetSocketAddress::getHostString).map(str -> str.toLowerCase(Locale.ROOT)).orElse("");
        List<String> serversToTry = this.server.getConfiguration().getForcedHosts().getOrDefault(virtualHostStr, this.server.getConfiguration().getAttemptConnectionOrder());
        return this.attemptPingPassthrough(connection, passthroughMode, serversToTry, shownVersion, virtualHostStr);
    }
}

