/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.title;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.title.LegacyTitlePacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleActionbarPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleClearPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleSubtitlePacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleTextPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleTimesPacket;
import io.netty.buffer.ByteBuf;

public abstract class GenericTitlePacket
implements MinecraftPacket {
    private ActionType action;

    protected void setAction(ActionType action) {
        this.action = action;
    }

    public final ActionType getAction() {
        return this.action;
    }

    public ComponentHolder getComponent() {
        throw new UnsupportedOperationException("Invalid function for this TitlePacket ActionType");
    }

    public void setComponent(ComponentHolder component) {
        throw new UnsupportedOperationException("Invalid function for this TitlePacket ActionType");
    }

    public int getFadeIn() {
        throw new UnsupportedOperationException("Invalid function for this TitlePacket ActionType");
    }

    public void setFadeIn(int fadeIn) {
        throw new UnsupportedOperationException("Invalid function for this TitlePacket ActionType");
    }

    public int getStay() {
        throw new UnsupportedOperationException("Invalid function for this TitlePacket ActionType");
    }

    public void setStay(int stay) {
        throw new UnsupportedOperationException("Invalid function for this TitlePacket ActionType");
    }

    public int getFadeOut() {
        throw new UnsupportedOperationException("Invalid function for this TitlePacket ActionType");
    }

    public void setFadeOut(int fadeOut) {
        throw new UnsupportedOperationException("Invalid function for this TitlePacket ActionType");
    }

    @Override
    public final void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        throw new UnsupportedOperationException();
    }

    public static GenericTitlePacket constructTitlePacket(ActionType type, ProtocolVersion version) {
        GenericTitlePacket packet = null;
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_17)) {
            packet = switch (type.ordinal()) {
                case 2 -> new TitleActionbarPacket();
                case 1 -> new TitleSubtitlePacket();
                case 3 -> new TitleTimesPacket();
                case 0 -> new TitleTextPacket();
                case 4, 5 -> new TitleClearPacket();
                default -> throw new IllegalArgumentException("Invalid ActionType");
            };
        } else {
            packet = new LegacyTitlePacket();
        }
        ((GenericTitlePacket)packet).setAction(type);
        return packet;
    }

    public static enum ActionType {
        SET_TITLE(0),
        SET_SUBTITLE(1),
        SET_ACTION_BAR(2),
        SET_TIMES(3),
        HIDE(4),
        RESET(5);

        private final int action;

        private ActionType(int action) {
            this.action = action;
        }

        public int getAction(ProtocolVersion version) {
            return version.lessThan(ProtocolVersion.MINECRAFT_1_11) ? (this.action > 2 ? this.action - 1 : this.action) : this.action;
        }
    }
}

